/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.security.AuthenticationService;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.tx.TxService;

public class JbpmContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_JBPM_CONTEXT_NAME = "default.jbpm.context";
    private final Services services;
    private final ObjectFactory objectFactory;
    private Set autoSaveProcessInstances;
    private boolean isClosed;

    public JbpmContext(Services services, ObjectFactory objectFactory) {
        if (services == null) {
            throw new IllegalArgumentException("null services");
        }
        this.services = services;
        this.objectFactory = objectFactory;
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new JbpmException(this + " is closed");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        RuntimeException saveException = this.autoSave();
        RuntimeException serviceException = this.closeServices();
        this.isClosed = true;
        if (saveException != null) {
            throw saveException;
        }
        if (serviceException != null) {
            throw serviceException;
        }
    }

    private RuntimeException autoSave() {
        if (this.autoSaveProcessInstances != null) {
            try {
                Iterator iter = this.autoSaveProcessInstances.iterator();
                while (iter.hasNext()) {
                    ProcessInstance processInstance = (ProcessInstance)iter.next();
                    this.save(processInstance);
                }
            }
            catch (RuntimeException e) {
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException closeServices() {
        try {
            this.services.close();
            RuntimeException runtimeException = null;
            return runtimeException;
        }
        catch (RuntimeException e) {
            RuntimeException runtimeException = e;
            return runtimeException;
        }
        finally {
            JbpmConfiguration configuration = this.getJbpmConfiguration();
            if (configuration != null) {
                configuration.popJbpmContext(this);
            }
        }
    }

    public static JbpmContext getCurrentJbpmContext() {
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getCurrentJbpmConfiguration();
        return jbpmConfiguration != null ? jbpmConfiguration.getCurrentJbpmContext() : null;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        this.getGraphSession().deployProcessDefinition(processDefinition);
    }

    public List getTaskList() {
        String actorId = this.getActorId();
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getTaskList(String actorId) {
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getGroupTaskList(List actorIds) {
        return this.getTaskMgmtSession().findPooledTaskInstances(actorIds);
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        return this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
    }

    public TaskInstance getTaskInstance(long taskInstanceId) {
        return this.getTaskMgmtSession().getTaskInstance(taskInstanceId);
    }

    public TaskInstance loadTaskInstanceForUpdate(long taskInstanceId) {
        TaskInstance taskInstance = this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
        this.addAutoSaveTaskInstance(taskInstance);
        return taskInstance;
    }

    public TaskInstance getTaskInstanceForUpdate(long taskInstanceId) {
        TaskInstance taskInstance = this.getTaskMgmtSession().getTaskInstance(taskInstanceId);
        if (taskInstance != null) {
            this.addAutoSaveTaskInstance(taskInstance);
        }
        return taskInstance;
    }

    public Token loadToken(long tokenId) {
        return this.getGraphSession().loadToken(tokenId);
    }

    public Token getToken(long tokenId) {
        return this.getGraphSession().getToken(tokenId);
    }

    public Token loadTokenForUpdate(long tokenId) {
        Token token = this.getGraphSession().loadToken(tokenId);
        this.addAutoSaveToken(token);
        return token;
    }

    public Token getTokenForUpdate(long tokenId) {
        Token token = this.getGraphSession().getToken(tokenId);
        if (token != null) {
            this.addAutoSaveToken(token);
        }
        return token;
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        return this.getGraphSession().loadProcessInstance(processInstanceId);
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.getGraphSession().getProcessInstance(processInstanceId);
    }

    public ProcessInstance loadProcessInstanceForUpdate(long processInstanceId) {
        ProcessInstance processInstance = this.getGraphSession().loadProcessInstance(processInstanceId);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public ProcessInstance getProcessInstanceForUpdate(long processInstanceId) {
        ProcessInstance processInstance = this.getGraphSession().getProcessInstance(processInstanceId);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        return this.getGraphSession().getProcessInstance(processDefinition, key);
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        return this.getGraphSession().loadProcessInstance(processDefinition, key);
    }

    public ProcessInstance getProcessInstanceForUpdate(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getGraphSession().getProcessInstance(processDefinition, key);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance loadProcessInstanceForUpdate(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getGraphSession().loadProcessInstance(processDefinition, key);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance newProcessInstance(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        return new ProcessInstance(processDefinition);
    }

    public ProcessInstance newProcessInstanceForUpdate(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public void save(ProcessInstance processInstance) {
        this.ensureOpen();
        this.services.save(processInstance, this);
    }

    public void save(Token token) {
        this.save(token.getProcessInstance());
    }

    public void save(TaskInstance taskInstance) {
        this.save(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    public void setRollbackOnly() {
        this.ensureOpen();
        TxService txService = this.services.getTxService();
        if (txService == null) {
            throw new JbpmException("no transaction service configured");
        }
        txService.setRollbackOnly();
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceFactory getServiceFactory(String name) {
        return this.services.getServiceFactory(name);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return (JbpmConfiguration)this.objectFactory.createObject("jbpm.configuration");
    }

    public SessionFactory getSessionFactory() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            return dbPersistenceService.getSessionFactory();
        }
        return null;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setSessionFactory(sessionFactory);
        }
    }

    public Session getSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            return dbPersistenceService.getSession();
        }
        return null;
    }

    public void setSession(Session session) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setSession(session);
        }
    }

    public Connection getConnection() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            return dbPersistenceService.getConnection();
        }
        return null;
    }

    public void setConnection(Connection connection) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setConnection(connection);
        }
    }

    public ContextSession getContextSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getContextSession() : null;
    }

    public LoggingSession getLoggingSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getLoggingSession() : null;
    }

    public JobSession getJobSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getJobSession() : null;
    }

    public GraphSession getGraphSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getGraphSession() : null;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getTaskMgmtSession() : null;
    }

    public String getActorId() {
        return this.services.getAuthenticationService().getActorId();
    }

    public void setActorId(String actorId) {
        this.ensureOpen();
        AuthenticationService authService = this.services.getAuthenticationService();
        if (authService != null) {
            authService.setActorId(actorId);
        }
    }

    public void addAutoSaveProcessInstance(ProcessInstance processInstance) {
        this.ensureOpen();
        if (this.autoSaveProcessInstances == null) {
            this.autoSaveProcessInstances = new HashSet();
        }
        this.autoSaveProcessInstances.add(processInstance);
    }

    public void addAutoSaveToken(Token token) {
        this.addAutoSaveProcessInstance(token.getProcessInstance());
    }

    public void addAutoSaveTaskInstance(TaskInstance taskInstance) {
        this.addAutoSaveProcessInstance(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    private PersistenceService getPersistenceService() {
        this.ensureOpen();
        return this.services.getPersistenceService();
    }

    public String toString() {
        String resourceName;
        JbpmConfiguration configuration = this.getJbpmConfiguration();
        if (configuration != null && (resourceName = configuration.getResourceName()) != null) {
            return "JbpmContext(" + resourceName + ')';
        }
        return "JbpmContext@" + Integer.toHexString(this.hashCode());
    }
}

