/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.job.ExecuteNodeJob;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.util.Clock;

public class Node
extends GraphElement
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected List leavingTransitions;
    private transient Map leavingTransitionMap;
    protected Set arrivingTransitions;
    protected Action action;
    protected SuperState superState;
    protected boolean isAsync;
    protected boolean isAsyncExclusive;
    private static final String[] EVENT_TYPES = new String[]{"node-enter", "node-leave", "before-signal", "after-signal"};
    public static final String[] supportedEventTypes = (String[])EVENT_TYPES.clone();

    public NodeType getNodeType() {
        return NodeType.Node;
    }

    public String getNameExt() {
        String name = this.getName();
        if (name == null) {
            name = "#anonymous" + this.getNodeType();
        }
        return name;
    }

    public String[] getSupportedEventTypes() {
        return (String[])EVENT_TYPES.clone();
    }

    public Node() {
    }

    public Node(String name) {
        super(name);
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
    }

    public void write(Element nodeElement) {
        if (this.action != null) {
            String actionName = ActionTypes.getActionName(this.action.getClass());
            Element actionElement = nodeElement.addElement(actionName);
            this.action.write(actionElement);
        }
    }

    public List getLeavingTransitions() {
        return this.leavingTransitions;
    }

    public List getLeavingTransitionsList() {
        return this.leavingTransitions;
    }

    public Map getLeavingTransitionsMap() {
        if (this.leavingTransitionMap == null && this.leavingTransitions != null) {
            this.leavingTransitionMap = new HashMap();
            ListIterator iter = this.leavingTransitions.listIterator(this.leavingTransitions.size());
            while (iter.hasPrevious()) {
                Transition leavingTransition = (Transition)iter.previous();
                this.leavingTransitionMap.put(leavingTransition.getName(), leavingTransition);
            }
        }
        return this.leavingTransitionMap;
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("leaving transition is null");
        }
        if (this.leavingTransitions == null) {
            this.leavingTransitions = new ArrayList();
        }
        leavingTransition.from = this;
        this.leavingTransitions.add(leavingTransition);
        this.leavingTransitionMap = null;
        return leavingTransition;
    }

    public void removeLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("leaving transition is null");
        }
        if (this.leavingTransitions != null && this.leavingTransitions.remove(leavingTransition)) {
            leavingTransition.from = null;
            this.leavingTransitionMap = null;
        }
    }

    public boolean hasLeavingTransition(String transitionName) {
        return this.getLeavingTransition(transitionName) != null;
    }

    public Transition getLeavingTransition(String transitionName) {
        if (this.leavingTransitions != null) {
            Iterator i = this.leavingTransitions.iterator();
            while (i.hasNext()) {
                Transition transition = (Transition)i.next();
                if (!(transitionName != null ? transitionName.equals(transition.getName()) : transition.getName() == null)) continue;
                return transition;
            }
        }
        return this.superState != null ? this.superState.getLeavingTransition(transitionName) : null;
    }

    public boolean hasNoLeavingTransitions() {
        return !(this.leavingTransitions != null && !this.leavingTransitions.isEmpty() || this.superState != null && !this.superState.hasNoLeavingTransitions());
    }

    public String generateNextLeavingTransitionName() {
        String name = null;
        if (this.leavingTransitions != null && this.containsName(this.leavingTransitions, null)) {
            int n = 1;
            while (this.containsName(this.leavingTransitions, Integer.toString(n))) {
                ++n;
            }
            name = Integer.toString(n);
        }
        return name;
    }

    boolean containsName(List leavingTransitions, String name) {
        Iterator iter = leavingTransitions.iterator();
        while (iter.hasNext()) {
            Transition transition = (Transition)iter.next();
            if (!(name != null ? name.equals(transition.getName()) : transition.getName() == null)) continue;
            return true;
        }
        return false;
    }

    public Transition getDefaultLeavingTransition() {
        if (this.leavingTransitions != null && !this.leavingTransitions.isEmpty()) {
            Iterator i = this.leavingTransitions.iterator();
            while (i.hasNext()) {
                Transition transition = (Transition)i.next();
                if (transition.getCondition() != null) continue;
                return transition;
            }
            return (Transition)this.leavingTransitions.get(0);
        }
        if (this.superState != null) {
            return this.superState.getDefaultLeavingTransition();
        }
        return null;
    }

    public void reorderLeavingTransition(int oldIndex, int newIndex) {
        if (this.leavingTransitions != null && Math.min(oldIndex, newIndex) >= 0 && Math.max(oldIndex, newIndex) < this.leavingTransitions.size()) {
            Object transition = this.leavingTransitions.remove(oldIndex);
            this.leavingTransitions.add(newIndex, transition);
        }
    }

    public Set getArrivingTransitions() {
        return this.arrivingTransitions;
    }

    public Transition addArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("arriving transition is null");
        }
        if (this.arrivingTransitions == null) {
            this.arrivingTransitions = new HashSet();
        }
        arrivingTransition.to = this;
        this.arrivingTransitions.add(arrivingTransition);
        return arrivingTransition;
    }

    public void removeArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("arriving transition is null");
        }
        if (this.arrivingTransitions != null && this.arrivingTransitions.remove(arrivingTransition)) {
            arrivingTransition.to = null;
        }
    }

    public GraphElement getParent() {
        GraphElement parent = this.superState != null ? this.superState : this.processDefinition;
        return parent;
    }

    public void enter(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        token.setNode(this);
        token.setNodeEnter(Clock.getCurrentTime());
        this.fireEvent("node-enter", executionContext);
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        if (this.isAsync) {
            ExecuteNodeJob job = this.createAsyncContinuationJob(token);
            executionContext.getJbpmContext().getServices().getMessageService().send(job);
            token.lock(job.toString());
        } else {
            this.execute(executionContext);
        }
    }

    protected ExecuteNodeJob createAsyncContinuationJob(Token token) {
        ExecuteNodeJob job = new ExecuteNodeJob(token);
        job.setNode(this);
        job.setDueDate(new Date());
        job.setExclusive(this.isAsyncExclusive);
        return job;
    }

    public void execute(ExecutionContext executionContext) {
        if (this.action != null) {
            this.executeAction(this.action, executionContext);
        } else {
            this.leave(executionContext);
        }
    }

    public void leave(ExecutionContext executionContext) {
        this.leave(executionContext, this.getDefaultLeavingTransition());
    }

    public void leave(ExecutionContext executionContext, String transitionName) {
        Transition transition = this.getLeavingTransition(transitionName);
        if (transition == null) {
            throw new JbpmException("no such transition: " + transitionName);
        }
        this.leave(executionContext, transition);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        if (transition == null) {
            throw new JbpmException("transition is null");
        }
        Token token = executionContext.getToken();
        token.setNode(this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        if (token.getNodeEnter() != null) {
            this.addNodeLog(token);
        }
        executionContext.setTransitionSource(this);
        transition.take(executionContext);
    }

    protected void addNodeLog(Token token) {
        token.addLog(new NodeLog(this, token.getNodeEnter(), Clock.getCurrentTime()));
    }

    public ProcessDefinition getProcessDefinition() {
        return this.superState != null ? this.superState.getProcessDefinition() : this.processDefinition;
    }

    public void setName(String name) {
        if (Node.isDifferent(this.name, name)) {
            String oldName = this.name;
            if (this.superState != null) {
                if (this.superState.hasNode(name)) {
                    throw new IllegalArgumentException("cannot rename " + this + " because " + this.superState + " already has a node named " + name);
                }
                Map nodes = this.superState.getNodesMap();
                nodes.remove(oldName);
                nodes.put(name, this);
            } else if (this.processDefinition != null) {
                if (this.processDefinition.hasNode(name)) {
                    throw new IllegalArgumentException("cannot rename " + this + " because " + this.processDefinition + " already has a node named " + name);
                }
                Map nodeMap = this.processDefinition.getNodesMap();
                nodeMap.remove(oldName);
                nodeMap.put(name, this);
            }
            this.name = name;
        }
    }

    private static boolean isDifferent(String name1, String name2) {
        return !(name1 == null ? name2 == null : name1.equals(name2));
    }

    public String getFullyQualifiedName() {
        return this.superState != null ? this.superState.getFullyQualifiedName() + '/' + this.name : this.name;
    }

    public boolean isSuperStateNode() {
        return false;
    }

    public List getNodes() {
        return null;
    }

    public SuperState getSuperState() {
        return this.superState;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public boolean isAsyncExclusive() {
        return this.isAsyncExclusive;
    }

    public void setAsyncExclusive(boolean isAsyncExclusive) {
        this.isAsyncExclusive = isAsyncExclusive;
        if (isAsyncExclusive) {
            this.isAsync = true;
        }
    }

    public static class NodeType
    implements Serializable {
        private final String name;
        private static final Map values = new HashMap();
        private static final long serialVersionUID = 1L;
        public static final NodeType Node = new NodeType("Node");
        public static final NodeType StartState = new NodeType("StartState");
        public static final NodeType EndState = new NodeType("EndState");
        public static final NodeType State = new NodeType("State");
        public static final NodeType Task = new NodeType("Task");
        public static final NodeType Fork = new NodeType("Fork");
        public static final NodeType Join = new NodeType("Join");
        public static final NodeType Decision = new NodeType("Decision");

        protected NodeType(String name) {
            this.name = name;
            values.put(name, this);
        }

        public String toString() {
            return this.name;
        }

        public static NodeType valueOf(String name) {
            return (NodeType)values.get(name);
        }

        private Object readResolve() throws ObjectStreamException {
            NodeType nodeType = NodeType.valueOf(this.name);
            if (nodeType == null) {
                throw new InvalidObjectException("invalid node type: " + this.name);
            }
            return nodeType;
        }
    }
}

