/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.BeanInstantiator;
import org.jbpm.instantiation.ConfigurationPropertyInstantiator;
import org.jbpm.instantiation.ConstructorInstantiator;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.instantiation.ProcessClassLoader;
import org.jbpm.instantiation.XmlInstantiator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Delegation
implements Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Map instantiatorCache;
    private long id;
    protected String className;
    protected String configuration;
    protected String configType;
    protected ProcessDefinition processDefinition;
    private transient Object instance;
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Map createInstantiatorCache() {
        HashMap<String, Instantiator> instantiators = new HashMap<String, Instantiator>();
        instantiators.put(null, new FieldInstantiator());
        instantiators.put("field", new FieldInstantiator());
        instantiators.put("bean", new BeanInstantiator());
        instantiators.put("constructor", new ConstructorInstantiator());
        instantiators.put("configuration-property", new ConfigurationPropertyInstantiator());
        instantiators.put("xml", new XmlInstantiator());
        return instantiators;
    }

    public Delegation() {
    }

    public Delegation(Object instance) {
        this.instance = instance;
    }

    public Delegation(String className) {
        this.className = className;
    }

    public void read(Element delegateElement, JpdlXmlReader jpdlReader) {
        this.processDefinition = jpdlReader.getProcessDefinition();
        this.className = delegateElement.attributeValue("class");
        if (this.className == null) {
            jpdlReader.addWarning("no class specified in delegation: " + delegateElement.getPath());
        }
        this.configType = delegateElement.attributeValue("config-type");
        if (delegateElement.hasContent()) {
            this.configuration = jpdlReader.writeElementContent(delegateElement);
        }
    }

    public void write(Element element) {
        element.addAttribute("class", this.className);
        element.addAttribute("config-type", this.configType);
        String configuration = this.configuration;
        if (configuration != null) {
            try {
                Element actionElement = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
                element.appendContent((Branch)actionElement);
            }
            catch (DocumentException e) {
                log.error((Object)("could not parse configuration: " + configuration), (Throwable)e);
            }
        }
    }

    public Object getInstance() {
        if (this.instance == null) {
            this.instance = this.instantiate();
        }
        return this.instance;
    }

    public Object instantiate() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!$assertionsDisabled && !(classLoader instanceof ProcessClassLoader)) {
            throw new AssertionError(classLoader.getClass());
        }
        Instantiator instantiator = (Instantiator)instantiatorCache.get(this.configType);
        if (instantiator == null) {
            try {
                Class<?> instantiatorClass = Class.forName(this.configType, false, classLoader);
                try {
                    instantiator = (Instantiator)instantiatorClass.newInstance();
                    instantiatorCache.put(this.configType, instantiator);
                }
                catch (InstantiationException e) {
                    throw new JbpmException("failed to instantiate " + instantiatorClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new JbpmException(this.getClass() + " has no access to " + instantiatorClass, e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("could not load instantiator class " + this.configType, e);
            }
        }
        try {
            Class<?> delegationClass = Class.forName(this.className, false, classLoader);
            return instantiator.instantiate(delegationClass, this.configuration);
        }
        catch (ClassNotFoundException e) {
            throw new DelegationException("could not load delegation class " + this.className, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Delegation)) {
            return false;
        }
        Delegation other = (Delegation)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        return this.className.equals(other.getClassName()) && (this.configuration != null ? this.configuration.equals(other.getConfiguration()) : other.getConfiguration() == null);
    }

    public int hashCode() {
        int result = 2131399759 + this.className.hashCode();
        result = 702058657 * result + this.configuration != null ? this.configuration.hashCode() : 0;
        return result;
    }

    public String toString() {
        return "Delegation(" + this.className + ')';
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String instantiatorType) {
        this.configType = instantiatorType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    static {
        $assertionsDisabled = !Delegation.class.desiredAssertionStatus();
        instantiatorCache = Delegation.createInstantiatorCache();
        log = LogFactory.getLog((Class)Delegation.class);
    }
}

