/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.db;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.jbpm.JbpmException;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.tx.TxService;

public class DbPersistenceService
implements PersistenceService {
    private static final long serialVersionUID = 1L;
    protected final DbPersistenceServiceFactory persistenceServiceFactory;
    protected Connection connection;
    protected boolean mustConnectionBeClosed;
    protected Transaction transaction;
    protected boolean isTransactionEnabled;
    protected boolean isCurrentSessionEnabled;
    protected Session session;
    protected boolean mustSessionBeFlushed;
    protected boolean mustSessionBeClosed;
    protected GraphSession graphSession;
    protected TaskMgmtSession taskMgmtSession;
    protected JobSession jobSession;
    protected ContextSession contextSession;
    protected LoggingSession loggingSession;
    private Map customSessions;
    protected Services services;
    private static final Log log = LogFactory.getLog((Class)DbPersistenceService.class);

    public DbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        this.persistenceServiceFactory = persistenceServiceFactory;
        this.isTransactionEnabled = persistenceServiceFactory.isTransactionEnabled();
        this.isCurrentSessionEnabled = persistenceServiceFactory.isCurrentSessionEnabled();
    }

    public SessionFactory getSessionFactory() {
        return this.session != null ? this.session.getSessionFactory() : this.persistenceServiceFactory.getSessionFactory();
    }

    public Session getSession() {
        if (this.session == null) {
            SessionFactory sessionFactory = this.persistenceServiceFactory.getSessionFactory();
            if (this.isCurrentSessionEnabled) {
                this.session = sessionFactory.getCurrentSession();
                this.mustSessionBeFlushed = false;
                this.mustSessionBeClosed = false;
            } else {
                Connection connection = this.getConnection(false);
                this.session = connection != null ? sessionFactory.openSession(connection) : sessionFactory.openSession();
                this.mustSessionBeFlushed = true;
                this.mustSessionBeClosed = true;
            }
            if (this.isTransactionEnabled) {
                this.beginTransaction();
            }
        }
        return this.session;
    }

    public void beginTransaction() {
        this.transaction = this.session.beginTransaction();
        this.mustSessionBeFlushed = false;
    }

    public void endTransaction() {
        if (!this.isTransactionRollbackOnly()) {
            Exception commitException = this.commit();
            if (commitException != null) {
                this.rollback();
                this.closeSession();
                this.closeConnection();
                throw new JbpmPersistenceException("transaction commit failed", commitException);
            }
        } else {
            Exception rollbackException = this.rollback();
            if (rollbackException != null) {
                this.closeSession();
                this.closeConnection();
                throw new JbpmPersistenceException("transaction rollback failed", rollbackException);
            }
        }
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean resolveSession) {
        if (this.connection == null) {
            DataSource dataSource = this.persistenceServiceFactory.getDataSource();
            if (dataSource != null) {
                try {
                    this.connection = dataSource.getConnection();
                    this.mustConnectionBeClosed = true;
                }
                catch (SQLException e) {
                    throw new JbpmPersistenceException("connection to data source failed", e);
                }
            } else {
                Session session = this.session;
                if (session != null || resolveSession && (session = this.getSession()) != null) {
                    this.connection = session.connection();
                    SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)session.getSessionFactory();
                    ConnectionReleaseMode releaseMode = sessionFactory.getSettings().getConnectionReleaseMode();
                    this.mustConnectionBeClosed = releaseMode == ConnectionReleaseMode.AFTER_STATEMENT;
                }
            }
        }
        return this.connection;
    }

    public boolean isTransactionActive() {
        return this.transaction != null && this.transaction.isActive();
    }

    protected boolean isTransactionManagedExternally() {
        return !this.isTransactionEnabled;
    }

    protected boolean isTransactionRollbackOnly() {
        TxService txService = DbPersistenceService.getTxService();
        return txService != null ? txService.isRollbackOnly() : false;
    }

    public void close() {
        Exception flushException = this.flushSession();
        if (flushException != null) {
            this.closeSession();
            this.closeConnection();
            throw new JbpmPersistenceException("failed to flush hibernate session", flushException);
        }
        this.endTransaction();
        Exception closeSessionException = this.closeSession();
        if (closeSessionException != null) {
            this.closeConnection();
            throw new JbpmPersistenceException("failed to close hibernate session", closeSessionException);
        }
        Exception closeConnectionException = this.closeConnection();
        if (closeConnectionException != null) {
            throw new JbpmPersistenceException("failed to close hibernate connection", closeConnectionException);
        }
    }

    protected Exception commit() {
        if (!this.isTransactionManagedExternally() && this.transaction != null) {
            try {
                this.transaction.commit();
            }
            catch (RuntimeException e) {
                return e;
            }
        }
        return null;
    }

    protected Exception rollback() {
        if (this.isTransactionManagedExternally()) {
            throw new JbpmPersistenceException("cannot honor rollback request under external transaction manager");
        }
        if (this.transaction != null) {
            try {
                this.transaction.rollback();
            }
            catch (RuntimeException e) {
                return e;
            }
        }
        return null;
    }

    private Exception flushSession() {
        if (this.mustSessionBeFlushed) {
            if (this.session != null) {
                try {
                    this.session.flush();
                }
                catch (RuntimeException e) {
                    return e;
                }
            } else {
                log.warn((Object)"no hibernate session to flush");
            }
        }
        return null;
    }

    private Exception closeSession() {
        if (this.mustSessionBeClosed) {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (RuntimeException e) {
                    return e;
                }
            } else {
                log.warn((Object)"no hibernate session to close");
            }
        }
        return null;
    }

    private Exception closeConnection() {
        if (this.mustConnectionBeClosed) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (RuntimeException e) {
                    return e;
                }
                catch (SQLException e) {
                    return e;
                }
            } else {
                log.warn((Object)"no jdbc connection to close");
            }
        }
        return null;
    }

    public void assignId(Object object) {
        Session session = this.getSession();
        if (session != null) {
            try {
                session.save(object);
            }
            catch (HibernateException e) {
                throw new JbpmPersistenceException("could not assign id to " + object, e);
            }
        }
    }

    public GraphSession getGraphSession() {
        Session session;
        if (this.graphSession == null && (session = this.getSession()) != null) {
            this.graphSession = new GraphSession(session);
        }
        return this.graphSession;
    }

    public LoggingSession getLoggingSession() {
        Session session;
        if (this.loggingSession == null && (session = this.getSession()) != null) {
            this.loggingSession = new LoggingSession(session);
        }
        return this.loggingSession;
    }

    public JobSession getJobSession() {
        Session session;
        if (this.jobSession == null && (session = this.getSession()) != null) {
            this.jobSession = new JobSession(session);
        }
        return this.jobSession;
    }

    public ContextSession getContextSession() {
        Session session;
        if (this.contextSession == null && (session = this.getSession()) != null) {
            this.contextSession = new ContextSession(session);
        }
        return this.contextSession;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        Session session;
        if (this.taskMgmtSession == null && (session = this.getSession()) != null) {
            this.taskMgmtSession = new TaskMgmtSession(session);
        }
        return this.taskMgmtSession;
    }

    public Object getCustomSession(Class sessionClass) {
        if (this.customSessions == null) {
            this.customSessions = new IdentityHashMap();
        } else {
            Object customSession = this.customSessions.get(sessionClass);
            if (customSession != null) {
                return customSession;
            }
        }
        try {
            Constructor constructor = sessionClass.getConstructor(Session.class);
            try {
                Object customSession = constructor.newInstance(this.session);
                this.customSessions.put(sessionClass, customSession);
                return customSession;
            }
            catch (InstantiationException e) {
                throw new JbpmException(sessionClass + " is not instantiable", e);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(this.getClass() + " has no access to " + constructor, e);
            }
            catch (InvocationTargetException e) {
                throw new JbpmException(constructor + " threw exception", e.getCause());
            }
        }
        catch (NoSuchMethodException e) {
            throw new JbpmException("constructor not found: " + sessionClass.getName() + '(' + Session.class.getName() + ')', e);
        }
    }

    public DataSource getDataSource() {
        return this.persistenceServiceFactory.getDataSource();
    }

    public boolean isRollbackOnly() {
        return this.isTransactionRollbackOnly();
    }

    public void setRollbackOnly() {
        TxService txService = DbPersistenceService.getTxService();
        if (txService != null) {
            txService.setRollbackOnly();
        }
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        if (!rollbackOnly) {
            throw new IllegalArgumentException("cannot unmark transaction for rollback");
        }
        this.setRollbackOnly();
    }

    private static TxService getTxService() {
        return (TxService)Services.getCurrentService("tx", false);
    }

    public void setSession(Session session) {
        this.setSession(session, false);
    }

    public void setSessionWithoutDisablingTx(Session session) {
        this.setSession(session, true);
    }

    public void setSession(Session session, boolean keepTransactionEnabled) {
        this.session = session;
        if (this.isTransactionEnabled && !keepTransactionEnabled) {
            this.isTransactionEnabled = false;
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setContextSession(ContextSession contextSession) {
        this.contextSession = contextSession;
    }

    public void setDataSource(DataSource dataSource) {
        this.persistenceServiceFactory.setDataSource(dataSource);
    }

    public void setGraphSession(GraphSession graphSession) {
        this.graphSession = graphSession;
    }

    public void setLoggingSession(LoggingSession loggingSession) {
        this.loggingSession = loggingSession;
    }

    public void setJobSession(JobSession jobSession) {
        this.jobSession = jobSession;
    }

    public void setTaskMgmtSession(TaskMgmtSession taskMgmtSession) {
        this.taskMgmtSession = taskMgmtSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.persistenceServiceFactory.setSessionFactory(sessionFactory);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public boolean isTransactionEnabled() {
        return this.isTransactionEnabled;
    }

    public void setTransactionEnabled(boolean isTransactionEnabled) {
        this.isTransactionEnabled = isTransactionEnabled;
    }

    public static boolean isPersistenceException(Exception exception) {
        for (Throwable t = exception; t != null; t = t.getCause()) {
            if (!(t instanceof HibernateException)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLockingException(Exception exception) {
        for (Throwable t = exception; t != null; t = t.getCause()) {
            if (!(t instanceof StaleStateException) && !(t instanceof LockAcquisitionException)) continue;
            return true;
        }
        return false;
    }
}

