/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.ByteArrayInputStream;
import java.util.zip.ZipInputStream;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.def.ProcessDefinition;

public class DeployProcessCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -5861811926680981061L;
    private String xml;
    private byte[] par;

    public DeployProcessCommand() {
    }

    public DeployProcessCommand(byte[] par) {
        this.setPar(par);
    }

    public DeployProcessCommand(String xml) {
        this.setXml(xml);
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        ProcessDefinition processDefinition;
        if (this.par == null && this.xml == null) {
            throw new JbpmException("either xml string or process archive must be given.");
        }
        boolean debug = log.isDebugEnabled();
        if (this.par != null) {
            if (debug) {
                log.debug((Object)"parsing process from archive");
            }
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.par));
            processDefinition = ProcessDefinition.parseParZipInputStream(zipInputStream);
        } else {
            if (debug) {
                log.debug((Object)"parsing process from string");
            }
            processDefinition = ProcessDefinition.parseXmlString(this.xml);
        }
        jbpmContext.deployProcessDefinition(processDefinition);
        if (debug) {
            log.debug((Object)(processDefinition + " deployed successfully"));
        }
        return this.retrieveProcessDefinition(processDefinition);
    }

    public byte[] getPar() {
        return this.par;
    }

    public void setPar(byte[] par) {
        if (par == null) {
            throw new IllegalArgumentException("process archive is null");
        }
        this.par = par;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("xml is null");
        }
        this.xml = xml;
    }

    public DeployProcessCommand xml(String xml) {
        this.setXml(xml);
        return this;
    }

    public DeployProcessCommand par(byte[] par) {
        this.setPar(par);
        return this;
    }
}

