/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.bytes.ByteArray;
import org.jbpm.context.exe.Converter;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.util.CustomLoaderObjectInputStream;

public class SerializableToByteArrayConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    public boolean supports(Object value) {
        return value instanceof Serializable || value == null;
    }

    public Object convert(Object o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(memoryStream);
            objectStream.writeObject(o);
            objectStream.flush();
            return new ByteArray(memoryStream.toByteArray());
        }
        catch (IOException e) {
            throw new JbpmException("failed to serialize: " + o, e);
        }
    }

    public Object revert(Object o) {
        if (o == null) {
            return o;
        }
        ByteArray byteArray = (ByteArray)o;
        ByteArrayInputStream memoryStream = new ByteArrayInputStream(byteArray.getBytes());
        try {
            ObjectInputStream objectStream = new ObjectInputStream(memoryStream);
            return objectStream.readObject();
        }
        catch (IOException e) {
            throw new JbpmException("failed to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("serialized class not found", e);
        }
    }

    public Object revert(Object o, ProcessDefinition processDefinition) {
        ByteArray byteArray = (ByteArray)o;
        if (byteArray.getBytes().length > 0) {
            ByteArrayInputStream memoryStream = new ByteArrayInputStream(byteArray.getBytes());
            try {
                CustomLoaderObjectInputStream objectStream = new CustomLoaderObjectInputStream(memoryStream, JbpmConfiguration.getProcessClassLoader(processDefinition));
                return objectStream.readObject();
            }
            catch (IOException e) {
                throw new JbpmException("failed to deserialize object", e);
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("serialized class not found", e);
            }
        }
        return null;
    }
}

