/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.logging.exe;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.util.Clock;

public class LoggingInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    private List logs = new ArrayList();
    private transient List compositeLogStack = new ArrayList();
    private static final Log log = LogFactory.getLog(LoggingInstance.class);

    public synchronized void startCompositeLog(CompositeLog compositeLog) {
        this.addLog(compositeLog);
        this.compositeLogStack.add(compositeLog);
    }

    public synchronized void endCompositeLog() {
        this.compositeLogStack.remove(this.compositeLogStack.size() - 1);
    }

    public synchronized void addLog(ProcessLog processLog) {
        if (!this.compositeLogStack.isEmpty()) {
            CompositeLog compositeLog = (CompositeLog)this.compositeLogStack.get(this.compositeLogStack.size() - 1);
            compositeLog.addChild(processLog);
            processLog.setParent(compositeLog);
        }
        processLog.setDate(Clock.getCurrentTime());
        this.logs.add(processLog);
    }

    public List getLogs() {
        return this.logs;
    }

    public List getLogs(Class filterClass) {
        return LoggingInstance.getLogs(this.getLogs(), filterClass);
    }

    public static List getLogs(Collection logs, Class filterClass) {
        ArrayList filteredLogs = new ArrayList();
        if (logs != null) {
            for (Object log : logs) {
                if (!filterClass.isAssignableFrom(log.getClass())) continue;
                filteredLogs.add(log);
            }
        }
        return filteredLogs;
    }

    List getCompositeLogStack() {
        return Collections.unmodifiableList(this.compositeLogStack);
    }

    public void logLogs() {
        for (ProcessLog processLog : this.logs) {
            if (processLog.getParent() != null) continue;
            this.logLog("+-", processLog);
        }
    }

    private void logLog(String indentation, ProcessLog processLog) {
        CompositeLog compositeLog;
        log.debug((Object)(processLog.getToken() + "[" + processLog.getIndex() + "] " + processLog + " on " + processLog.getToken()));
        if (processLog instanceof CompositeLog && (compositeLog = (CompositeLog)processLog).getChildren() != null) {
            Iterator iter = compositeLog.getChildren().iterator();
            while (iter.hasNext()) {
                this.logLog("| " + indentation, (ProcessLog)iter.next());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.compositeLogStack = new ArrayList();
    }
}

