/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.jbpm.JbpmConfiguration;
import org.jbpm.util.ClassLoaderUtil;

public class AntHelper {
    private static final Map configurations = new HashMap();
    private static final Map jbpmConfigurations = new HashMap();

    private AntHelper() {
    }

    public static Configuration getConfiguration(String hibernateCfg, String hibernateProperties) {
        Object key = AntHelper.getKey(hibernateCfg, hibernateProperties);
        Configuration configuration = (Configuration)configurations.get(key);
        if (configuration == null) {
            configuration = new Configuration();
            configuration.configure(hibernateCfg);
            if (hibernateProperties != null) {
                Properties properties = ClassLoaderUtil.getProperties(hibernateProperties);
                configuration.addProperties(properties);
            }
            configurations.put(key, configuration);
        }
        return configuration;
    }

    public static JbpmConfiguration getJbpmConfiguration(String jbpmCfg) {
        JbpmConfiguration jbpmConfiguration = (JbpmConfiguration)jbpmConfigurations.get(jbpmCfg);
        if (jbpmConfiguration == null) {
            jbpmConfiguration = jbpmCfg == null ? JbpmConfiguration.getInstance() : JbpmConfiguration.getInstance(jbpmCfg);
            jbpmConfigurations.put(jbpmCfg, jbpmConfiguration);
        }
        return jbpmConfiguration;
    }

    static Object getKey(String cfg, String properties) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(cfg);
        key.add(properties);
        return key;
    }
}

