/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import org.jbpm.calendar.Day;
import org.jbpm.calendar.Duration;

public class DayPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int startHour;
    final int startMinute;
    final int endHour;
    final int endMinute;
    private final Day day;
    private final int index;

    public DayPart(String dayPartText, DateFormat timeFormat, Day day, int index) {
        ParsePosition parsePosition = new ParsePosition(Duration.indexOfNonWhite(dayPartText, 0));
        Date startTime = timeFormat.parse(dayPartText, parsePosition);
        if (startTime == null) {
            throw new IllegalArgumentException("failed to parse day part start time: " + dayPartText);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        this.startHour = calendar.get(11);
        this.startMinute = calendar.get(12);
        int separatorIndex = Duration.indexOfNonWhite(dayPartText, parsePosition.getIndex());
        if (dayPartText.charAt(separatorIndex) != '-') {
            throw new IllegalArgumentException("missing '-' in day part: " + dayPartText);
        }
        parsePosition.setIndex(separatorIndex + 1);
        Date endTime = timeFormat.parse(dayPartText, parsePosition);
        if (endTime == null) {
            throw new IllegalArgumentException("failed to parse day part end time: " + dayPartText);
        }
        calendar.setTime(endTime);
        int hour = calendar.get(11);
        this.endHour = hour == 0 ? 24 : hour;
        this.endMinute = calendar.get(12);
        this.day = day;
        this.index = index;
    }

    public Date add(Date date, Duration duration) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        long durationMillis = duration.getMilliseconds();
        if (duration.isNegative()) {
            long dayPartMillis = (long)(this.startHour - hour) * 3600000L + (long)(this.startMinute - minute) * 60000L;
            if (durationMillis >= dayPartMillis) {
                return duration.addTo(date);
            }
            Duration remainder = new Duration(durationMillis - dayPartMillis);
            Date dayPartStartDate = new Date(date.getTime() + dayPartMillis);
            DayPart previousDayPart = this.day.findPreviousDayPart(dayPartStartDate, this.index - 1);
            Date previousDayPartEnd = dayPartStartDate;
            return previousDayPart.add(previousDayPartEnd, remainder);
        }
        long dayPartMillis = (long)(this.endHour - hour) * 3600000L + (long)(this.endMinute - minute) * 60000L;
        if (durationMillis <= dayPartMillis) {
            return duration.addTo(date);
        }
        Duration remainder = new Duration(durationMillis - dayPartMillis);
        Date dayPartEndDate = new Date(date.getTime() + dayPartMillis);
        DayPart nextDayPart = this.day.findNextDayPart(dayPartEndDate, this.index + 1);
        Date nextDayPartStart = dayPartEndDate;
        return nextDayPart.add(nextDayPartStart, remainder);
    }

    public boolean isStartAfter(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int hour = calendar.get(11);
        return this.startHour > hour || this.startHour == hour && this.startMinute >= calendar.get(12);
    }

    boolean endsBefore(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int hour = calendar.get(11);
        return this.endHour < hour || this.endHour == hour && this.endMinute <= calendar.get(12);
    }

    public boolean includes(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return (this.startHour < hour || this.startHour == hour && this.startMinute <= minute) && (hour < this.endHour || hour == this.endHour && minute <= this.endMinute);
    }

    public Date getStartTime(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(11, this.startHour);
        calendar.set(12, this.startMinute);
        return calendar.getTime();
    }

    Date getEndTime(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(11, this.endHour);
        calendar.set(12, this.endMinute);
        return calendar.getTime();
    }
}

