/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractGetObjectBaseCommand
extends AbstractBaseCommand {
    static final Log log = LogFactory.getLog(AbstractGetObjectBaseCommand.class);
    private static final long serialVersionUID = 1L;
    private boolean includeAllVariables;
    private String[] variablesToInclude = new String[0];
    private transient JbpmContext jbpmContext;

    public AbstractGetObjectBaseCommand() {
    }

    public AbstractGetObjectBaseCommand(boolean includeAllVariables, boolean includeLogs) {
        this.includeAllVariables = includeAllVariables;
    }

    public AbstractGetObjectBaseCommand(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void retrieveTaskInstanceDetails(TaskInstance ti) {
        try {
            Token token = ti.getToken();
            ProcessInstance processInstance = token.getProcessInstance();
            ti.setProcessInstance(processInstance);
            Hibernate.initialize((Object)processInstance.getProcessDefinition());
            Hibernate.initialize((Object)token.getNode());
            Hibernate.initialize((Object)ti.getTask());
            this.retrieveVariables(ti);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("failure retrieving " + ti), (Throwable)ex);
        }
    }

    public ProcessInstance retrieveProcessInstance(ProcessInstance pi) {
        try {
            Hibernate.initialize((Object)pi.getProcessDefinition());
            this.retrieveToken(pi.getRootToken());
            Token superProcessToken = pi.getSuperProcessToken();
            if (superProcessToken != null) {
                Hibernate.initialize((Object)superProcessToken);
                Hibernate.initialize((Object)superProcessToken.getProcessInstance());
            }
            this.retrieveVariables(pi);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("failure retrieving " + pi), (Throwable)ex);
        }
        return pi;
    }

    public ProcessDefinition retrieveProcessDefinition(ProcessDefinition pd) {
        try {
            for (Transition transition : pd.getStartState().getLeavingTransitions()) {
                Hibernate.initialize((Object)transition);
            }
        }
        catch (RuntimeException ex) {
            log.warn((Object)("failure retrieving " + pd), (Throwable)ex);
        }
        return pd;
    }

    protected void retrieveToken(Token token) {
        this.retrieveNode(token.getNode());
        if (token.getChildren() != null) {
            Iterator iter = token.getChildren().values().iterator();
            while (iter.hasNext()) {
                this.retrieveToken((Token)iter.next());
            }
        }
    }

    protected void retrieveNode(Node node) {
        if (node != null) {
            Hibernate.initialize((Object)node);
            if (node.getSuperState() != null) {
                this.retrieveNode(node.getSuperState());
            }
        }
    }

    public void retrieveVariables(ProcessInstance pi) {
        if (this.includeAllVariables) {
            pi.getContextInstance().getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                pi.getContextInstance().getVariable(this.variablesToInclude[i]);
            }
        }
    }

    public void retrieveVariables(TaskInstance ti) {
        if (this.includeAllVariables) {
            ti.getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                ti.getVariable(this.variablesToInclude[i]);
            }
        }
    }

    public boolean isIncludeAllVariables() {
        return this.includeAllVariables;
    }

    public void setIncludeAllVariables(boolean includeAllVariables) {
        this.includeAllVariables = includeAllVariables;
    }

    public String[] getVariablesToInclude() {
        return this.variablesToInclude;
    }

    public void setVariablesToInclude(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void setVariablesToInclude(String variableToInclude) {
        this.variablesToInclude = new String[]{variableToInclude};
    }

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    protected void setJbpmContext(JbpmContext jbpmContext) {
        this.jbpmContext = jbpmContext;
    }

    public AbstractGetObjectBaseCommand variablesToInclude(String[] variablesToInclude) {
        this.setVariablesToInclude(variablesToInclude);
        return this;
    }

    public AbstractGetObjectBaseCommand variablesToInclude(String variableToInclude) {
        this.setVariablesToInclude(variableToInclude);
        return this;
    }

    public AbstractGetObjectBaseCommand includeAllVariables(boolean includeAllVariables) {
        this.setIncludeAllVariables(includeAllVariables);
        return this;
    }
}

