/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.log.VariableDeleteLog;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.db.DbLoggingService;

public abstract class VariableContainer
implements Serializable {
    protected Map variableInstances;
    private static final long serialVersionUID = 520258491083406913L;
    private static final Log log = LogFactory.getLog(VariableContainer.class);

    protected abstract VariableContainer getParentVariableContainer();

    public abstract Token getToken();

    public Object getVariable(String name) {
        Object value = null;
        if (this.hasVariableLocally(name)) {
            value = this.getVariableLocally(name);
        } else {
            VariableContainer parent = this.getParentVariableContainer();
            if (parent != null) {
                value = parent.getVariable(name);
            }
        }
        return value;
    }

    public void setVariable(String name, Object value) {
        VariableContainer parent = this.getParentVariableContainer();
        if (this.hasVariableLocally(name) || parent == null) {
            this.setVariableLocally(name, value);
        } else {
            parent.setVariable(name, value);
        }
    }

    public boolean hasVariable(String name) {
        if (this.hasVariableLocally(name)) {
            return true;
        }
        VariableContainer parent = this.getParentVariableContainer();
        if (parent != null) {
            return parent.hasVariable(name);
        }
        return false;
    }

    public void deleteVariable(String name) {
        if (name == null) {
            throw new JbpmException("variable name is null");
        }
        if (this.hasVariableLocally(name)) {
            this.deleteVariableLocally(name);
        }
    }

    public void addVariables(Map variables) {
        this.setVariables(variables);
    }

    public void setVariables(Map variables) {
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                this.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public Map getVariables() {
        Map variables = this.getVariablesLocally();
        VariableContainer parent = this.getParentVariableContainer();
        if (parent != null) {
            Map parentVariables = parent.getVariablesLocally();
            parentVariables.putAll(variables);
            variables = parentVariables;
        }
        return variables;
    }

    public Map getVariablesLocally() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.variableInstances != null) {
            for (Map.Entry entry : this.variableInstances.entrySet()) {
                String name = (String)entry.getKey();
                VariableInstance variableInstance = (VariableInstance)entry.getValue();
                if (variables.containsKey(name)) continue;
                variables.put(name, variableInstance.getValue());
            }
        }
        return variables;
    }

    public boolean hasVariableLocally(String name) {
        return this.variableInstances != null && this.variableInstances.containsKey(name);
    }

    public Object getVariableLocally(String name) {
        Object value = null;
        if (this.hasVariableLocally(name)) {
            value = this.getVariableInstance(name).getValue();
        }
        return value;
    }

    public void deleteVariableLocally(String name) {
        this.deleteVariableInstance(name);
    }

    public void setVariableLocally(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("variable name is null");
        }
        VariableInstance variableInstance = this.getVariableInstance(name);
        if (variableInstance != null && !variableInstance.supports(value)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(variableInstance.getToken() + " unsets '" + name + "' due to type change"));
            }
            this.deleteVariableInstance(name);
            variableInstance = null;
        }
        if (variableInstance != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(variableInstance.getToken() + " sets '" + name + "' to " + value));
            }
            variableInstance.setValue(value);
        } else {
            Token token = this.getToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)(token + " initializes '" + name + "' to " + value));
            }
            this.addVariableInstance(VariableInstance.create(token, name, value));
        }
    }

    public VariableInstance getVariableInstance(String name) {
        return this.variableInstances != null ? (VariableInstance)this.variableInstances.get(name) : null;
    }

    public Map getVariableInstances() {
        return this.variableInstances;
    }

    public void addVariableInstance(VariableInstance variableInstance) {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap();
        }
        this.variableInstances.put(variableInstance.getName(), variableInstance);
        ContextInstance contextInstance = this.getContextInstance();
        if (contextInstance != null) {
            contextInstance.addUpdatedVariableContainer(this);
        }
    }

    public void deleteVariableInstance(String name) {
        VariableInstance variableInstance;
        if (this.variableInstances != null && (variableInstance = (VariableInstance)this.variableInstances.remove(name)) != null) {
            Session session;
            variableInstance.removeReferences();
            this.getToken().addLog(new VariableDeleteLog(variableInstance));
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            if (jbpmContext != null && !(jbpmContext.getServices().getLoggingService() instanceof DbLoggingService) && (session = jbpmContext.getSession()) != null) {
                session.delete((Object)variableInstance);
            }
        }
    }

    public ContextInstance getContextInstance() {
        Token token = this.getToken();
        return token != null ? token.getProcessInstance().getContextInstance() : null;
    }

    public static Collection getUpdatedVariableContainers(ProcessInstance processInstance) {
        return processInstance.getContextInstance().updatedVariableContainers;
    }
}

