/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.Script;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Join
extends Node {
    private static final long serialVersionUID = 1L;
    private String parentLockMode;
    private boolean isDiscriminator;
    private Collection tokenNames;
    private Script script;
    private int nOutOfM = -1;
    private static final Log log = LogFactory.getLog(Join.class);

    public Join() {
    }

    public Join(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Join;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        String lock = element.attributeValue("lock");
        if (lock != null) {
            LockMode lockMode = LockMode.parse((String)lock);
            if (lockMode != null) {
                this.parentLockMode = lockMode.toString();
            } else if ("pessimistic".equals(lock)) {
                this.parentLockMode = LockMode.UPGRADE.toString();
            } else {
                jpdlReader.addError("invalid parent lock mode '" + lock + "'");
            }
        }
    }

    public void enter(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        token.end(false);
        token.setAbleToReactivateParent(true);
        super.enter(executionContext);
    }

    public void execute(ExecutionContext executionContext) {
        boolean reactivateParent;
        Session session;
        JbpmContext jbpmContext;
        Token arrivingToken = executionContext.getToken();
        if (!arrivingToken.isAbleToReactivateParent()) {
            return;
        }
        arrivingToken.setAbleToReactivateParent(false);
        if (this.parentLockMode != null && (jbpmContext = executionContext.getJbpmContext()) != null && (session = jbpmContext.getSession()) != null) {
            LockMode lockMode = LockMode.parse((String)this.parentLockMode);
            ProcessInstance processInstance = (ProcessInstance)session.load(ProcessInstance.class, (Serializable)new Long(arrivingToken.getProcessInstance().getId()), lockMode);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " acquires " + lockMode + " lock on " + processInstance));
            }
        }
        Token parentToken = arrivingToken.getParent();
        if (this.isDiscriminator) {
            reactivateParent = true;
        } else if (this.tokenNames != null) {
            reactivateParent = !parentToken.hasActiveChildren() && this.mustParentBeReactivated(parentToken, this.tokenNames);
        } else if (this.script != null) {
            reactivateParent = this.evaluateScript(executionContext);
        } else if (this.nOutOfM != -1) {
            int n = 0;
            for (Token childToken : parentToken.getChildren().values()) {
                if (!this.equals(childToken.getNode())) continue;
                ++n;
            }
            reactivateParent = n >= this.nOutOfM;
        } else {
            Set tokenNames = parentToken.getChildren().keySet();
            boolean bl = reactivateParent = !parentToken.hasActiveChildren() && this.mustParentBeReactivated(parentToken, tokenNames);
        }
        if (reactivateParent) {
            for (Token childToken : parentToken.getChildren().values()) {
                childToken.setAbleToReactivateParent(false);
            }
            parentToken.unlock(parentToken.getNode().toString());
            this.leave(new ExecutionContext(parentToken));
        }
    }

    private boolean evaluateScript(ExecutionContext executionContext) {
        Map outputMap = this.script.eval(executionContext);
        if (outputMap.size() == 1) {
            Object result = outputMap.values().iterator().next();
            if (result instanceof Collection) {
                Token parentToken = executionContext.getToken().getParent();
                return !parentToken.hasActiveChildren() && this.mustParentBeReactivated(parentToken, (Collection)result);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return result != null;
        }
        throw new JbpmException("expected " + this.script + " to write one variable, output was: " + outputMap);
    }

    private boolean mustParentBeReactivated(Token parentToken, Collection childTokenNames) {
        return this.mustParentBeReactivated(parentToken, childTokenNames.iterator());
    }

    public boolean mustParentBeReactivated(Token parentToken, Iterator childTokenNames) {
        while (childTokenNames.hasNext()) {
            String childTokenName = (String)childTokenNames.next();
            Token childToken = parentToken.getChild(childTokenName);
            if (!childToken.isAbleToReactivateParent()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(parentToken + " does not leave " + this + " as " + childToken + " is still active"));
            }
            return false;
        }
        return true;
    }

    public String getParentLockMode() {
        return this.parentLockMode;
    }

    public void setParentLockMode(String parentLockMode) {
        this.parentLockMode = parentLockMode;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public Collection getTokenNames() {
        return this.tokenNames;
    }

    public void setTokenNames(Collection tokenNames) {
        this.tokenNames = tokenNames;
    }

    public boolean isDiscriminator() {
        return this.isDiscriminator;
    }

    public void setDiscriminator(boolean isDiscriminator) {
        this.isDiscriminator = isDiscriminator;
    }

    public int getNOutOfM() {
        return this.nOutOfM;
    }

    public void setNOutOfM(int nOutOfM) {
        this.nOutOfM = nOutOfM;
    }
}

