/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;

public class ProcessClassLoader
extends ClassLoader {
    private ProcessDefinition processDefinition;
    private long processDefinitionId;
    private final JbpmConfiguration jbpmConfiguration;
    private final URLStreamHandler urlStreamHandler = new URLStreamHandler(){

        protected URLConnection openConnection(URL url) throws IOException {
            return new ProcessUrlConnection(url);
        }
    };

    public ProcessClassLoader(ClassLoader parent, ProcessDefinition processDefinition) {
        this(parent, processDefinition, null);
    }

    ProcessClassLoader(ClassLoader parent, ProcessDefinition processDefinition, JbpmConfiguration jbpmConfiguration) {
        super(parent);
        long id = processDefinition.getId();
        if (id != 0L) {
            this.processDefinitionId = id;
            if (jbpmConfiguration != null) {
                this.jbpmConfiguration = jbpmConfiguration;
            } else {
                JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
                if (jbpmContext == null) {
                    throw new JbpmException("no active jbpm context");
                }
                this.jbpmConfiguration = jbpmContext.getJbpmConfiguration();
            }
        } else {
            this.processDefinition = processDefinition;
            this.jbpmConfiguration = null;
        }
    }

    protected ProcessDefinition getProcessDefinition() {
        DbPersistenceService dbPersistenceService;
        PersistenceService persistenceService;
        JbpmContext jbpmContext;
        if (this.processDefinition != null) {
            return this.processDefinition;
        }
        if (this.jbpmConfiguration != null && (jbpmContext = this.jbpmConfiguration.getCurrentJbpmContext()) != null && (persistenceService = jbpmContext.getServices().getPersistenceService()) instanceof DbPersistenceService && (dbPersistenceService = (DbPersistenceService)persistenceService).isTransactionActive()) {
            return persistenceService.getGraphSession().loadProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    protected URL findResource(String name) {
        int off;
        FileDefinition fileDefinition;
        ProcessDefinition processDefinition = this.getProcessDefinition();
        if (processDefinition == null || (fileDefinition = processDefinition.getFileDefinition()) == null) {
            return null;
        }
        int len = name.length();
        for (off = 0; off < len && name.charAt(off) == '/'; ++off) {
        }
        name = off > 0 ? name.substring(off) : "classes/" + name;
        if (!fileDefinition.hasFile(name)) {
            return null;
        }
        try {
            return new URL("jbpm", null, -1, name, this.urlStreamHandler);
        }
        catch (MalformedURLException e) {
            throw new JbpmException("could not create url", e);
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        String packageName;
        FileDefinition fileDefinition;
        ProcessDefinition processDefinition = this.getProcessDefinition();
        if (processDefinition == null || (fileDefinition = processDefinition.getFileDefinition()) == null) {
            throw new ClassNotFoundException(className);
        }
        String fileName = "classes/" + className.replace('.', '/') + ".class";
        byte[] classBytes = fileDefinition.getBytes(fileName);
        if (classBytes == null) {
            throw new ClassNotFoundException(className);
        }
        int packageIndex = className.lastIndexOf(46);
        if (packageIndex != -1 && this.getPackage(packageName = className.substring(0, packageIndex)) == null) {
            this.definePackage(packageName, null, null, null, processDefinition.getName(), Integer.toString(processDefinition.getVersion()), null, null);
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    public static class BytesUrlConnection
    extends URLConnection {
        private final byte[] bytes;

        public BytesUrlConnection(byte[] bytes, URL u) {
            super(u);
            this.bytes = bytes;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class BytesUrlStreamHandler
    extends URLStreamHandler {
        private final byte[] bytes;

        public BytesUrlStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new BytesUrlConnection(this.bytes, u);
        }
    }

    private final class ProcessUrlConnection
    extends URLConnection {
        ProcessUrlConnection(URL url) {
            super(url);
        }

        public void connect() throws IOException {
            if (!this.connected) {
                this.connected = true;
            }
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            ProcessDefinition processDefinition = ProcessClassLoader.this.getProcessDefinition();
            if (processDefinition == null) {
                throw new IOException("no active jbpm context");
            }
            String fileName = this.url.getPath();
            FileDefinition fileDefinition = processDefinition.getFileDefinition();
            if (fileDefinition == null || !fileDefinition.hasFile(fileName)) {
                throw new FileNotFoundException(fileName);
            }
            byte[] fileContent = fileDefinition.getBytes(fileName);
            return new ByteArrayInputStream(fileContent);
        }
    }
}

