/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.NodeIterator;
import org.jbpm.util.XmlException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final DocumentBuilderFactory documentBuilderFactory = XmlUtil.createDocumentBuilderFactory();

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(false);
        return factory;
    }

    private XmlUtil() {
    }

    public static Document parseXmlText(String xml) {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        return XmlUtil.parseXmlInputSource(new InputSource(bais));
    }

    public static Document parseXmlResource(String resource, boolean useConfiguredLoader) {
        InputStream inputStream = ClassLoaderUtil.getStream(resource, useConfiguredLoader);
        if (inputStream == null) {
            throw new IllegalArgumentException("resource not found: " + resource);
        }
        InputSource inputSource = new InputSource(inputStream);
        return XmlUtil.parseXmlInputSource(inputSource);
    }

    public static Document parseXmlInputStream(InputStream inputStream) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputStream);
        }
        catch (IOException e) {
            throw new XmlException("could not read input", e);
        }
        catch (SAXException e) {
            throw new XmlException("failed to parse xml", e);
        }
        return document;
    }

    public static Document parseXmlInputSource(InputSource inputSource) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputSource);
        }
        catch (IOException e) {
            throw new XmlException("could not read input", e);
        }
        catch (SAXException e) {
            throw new XmlException("failed to parse xml", e);
        }
        return document;
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("failed to create document builder", e);
        }
    }

    public static String attribute(Element element, String attrName) {
        Attr attr = element.getAttributeNode(attrName);
        return attr != null ? attr.getValue() : null;
    }

    public static Iterator elementIterator(Element element, final String tagName) {
        return IteratorUtils.filteredIterator((Iterator)new NodeIterator(element), (Predicate)new Predicate(){

            public boolean evaluate(Object arg) {
                Node node = (Node)arg;
                return tagName.equals(node.getNodeName());
            }
        });
    }

    public static List elements(Element element, String tagName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !tagName.equals(child.getNodeName())) continue;
            elements.add(child);
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !tagName.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static Iterator elementIterator(Element element) {
        return IteratorUtils.filteredIterator((Iterator)new NodeIterator(element), (Predicate)ElementPredicate.INSTANCE);
    }

    public static List elements(Element element) {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            elements.add(child);
        }
        return elements;
    }

    public static Element element(Element element) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public static String toString(Element element) {
        if (element == null) {
            return "null";
        }
        DOMSource source = new DOMSource(element);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new XmlException("could not transform to string: " + element, e);
        }
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuffer buffer = new StringBuffer();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            buffer.append(child.getNodeValue());
        }
        return buffer.toString();
    }

    private static class ElementPredicate
    implements Predicate {
        static final Predicate INSTANCE = new ElementPredicate();

        private ElementPredicate() {
        }

        public boolean evaluate(Object arg) {
            return ((Node)arg).getNodeType() == 1;
        }
    }
}

