/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;

public class JobSession {
    private Session session;
    private static Log log = LogFactory.getLog(JobSession.class);

    public JobSession(Session session) {
        this.session = session;
    }

    public Job getFirstAcquirableJob(String lockOwner) {
        Job job = null;
        try {
            Query query = this.session.getNamedQuery("JobSession.getFirstAcquirableJob");
            query.setString("lockOwner", lockOwner);
            query.setTimestamp("now", new Date());
            query.setMaxResults(1);
            job = (Job)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get acquirable jobs", e);
        }
        return job;
    }

    public List findExclusiveJobs(String lockOwner, ProcessInstance processInstance) {
        List jobs = null;
        try {
            Query query = this.session.getNamedQuery("JobSession.findExclusiveJobs");
            query.setString("lockOwner", lockOwner);
            query.setTimestamp("now", new Date());
            query.setParameter("processInstance", (Object)processInstance);
            jobs = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't find exclusive jobs for thread '" + lockOwner + "' and process instance '" + processInstance + "'", e);
        }
        return jobs;
    }

    public Job getFirstDueJob(String lockOwner, Collection jobIdsToIgnore) {
        Job job = null;
        try {
            Query query = null;
            if (jobIdsToIgnore == null || jobIdsToIgnore.isEmpty()) {
                query = this.session.getNamedQuery("JobSession.getFirstDueJob");
                query.setString("lockOwner", lockOwner);
            } else {
                query = this.session.getNamedQuery("JobSession.getFirstDueJobExlcMonitoredJobs");
                query.setString("lockOwner", lockOwner);
                query.setParameterList("jobIdsToIgnore", jobIdsToIgnore);
            }
            query.setMaxResults(1);
            job = (Job)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get acquirable jobs", e);
        }
        return job;
    }

    public void saveJob(Job job) {
        Timer timer;
        Action action;
        this.session.saveOrUpdate((Object)job);
        if (job instanceof Timer && (action = (timer = (Timer)job).getAction()) != null && !this.session.contains((Object)action)) {
            log.debug((Object)"cascading timer save to action");
            this.session.save((Object)action);
        }
    }

    public void deleteJob(Job job) {
        this.session.delete((Object)job);
    }

    public Job loadJob(long jobId) {
        try {
            return (Job)this.session.load(Job.class, (Serializable)new Long(jobId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't load job '" + jobId + "'", e);
        }
    }

    public Timer loadTimer(long timerId) {
        try {
            return (Timer)this.session.load(Timer.class, (Serializable)new Long(timerId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't load timer " + timerId, e);
        }
    }

    public List loadJobs(long[] jobIds) {
        int jobCount = jobIds.length;
        Object[] jobs = new Long[jobCount];
        for (int i = 0; i < jobCount; ++i) {
            jobs[i] = new Long(jobIds[i]);
        }
        return this.session.createCriteria(Job.class).add(Restrictions.in((String)"id", (Object[])jobs)).list();
    }

    public Job getJob(long jobId) {
        try {
            return (Job)this.session.get(Job.class, (Serializable)new Long(jobId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get job '" + jobId + "'", e);
        }
    }

    public void suspendJobs(Token token) {
        try {
            Query query = this.session.getNamedQuery("JobSession.suspendJobs");
            query.setParameter("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't suspend jobs for " + token, e);
        }
    }

    public void resumeJobs(Token token) {
        try {
            Query query = this.session.getNamedQuery("JobSession.resumeJobs");
            query.setParameter("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't resume jobs for " + token, e);
        }
    }

    public void deleteTimersByName(String name, Token token) {
        try {
            log.debug((Object)("deleting timers by name '" + name + "' for " + token));
            Query query = this.session.getNamedQuery("JobSession.deleteTimersByName");
            query.setString("name", name);
            query.setParameter("token", (Object)token);
            int entityCount = query.executeUpdate();
            log.debug((Object)(entityCount + " timers by name '" + name + "' for " + token + " were deleted"));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't delete timers by name '" + name + "' for " + token, e);
        }
    }

    public void deleteJobsForProcessInstance(ProcessInstance processInstance) {
        log.debug((Object)("deleting timers for " + processInstance));
        Query query = this.session.getNamedQuery("JobSession.deleteTimersForProcessInstance");
        query.setParameter("processInstance", (Object)processInstance);
        int entityCount = query.executeUpdate();
        log.debug((Object)(entityCount + " remaining timers for " + processInstance + " were deleted"));
        log.debug((Object)("deleting execute-node-jobs for " + processInstance));
        query = this.session.getNamedQuery("JobSession.deleteExecuteNodeJobsForProcessInstance");
        query.setParameter("processInstance", (Object)processInstance);
        entityCount = query.executeUpdate();
        log.debug((Object)(entityCount + " remaining execute-node-jobs for " + processInstance + " were deleted"));
    }

    public List findJobsWithOverdueLockTime(Date treshold) {
        Query query = this.session.getNamedQuery("JobSession.findJobsWithOverdueLockTime");
        query.setDate("now", treshold);
        return query.list();
    }
}

