/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration;
    protected String name;
    protected int nbrOfThreads;
    protected int idleInterval;
    protected int maxIdleInterval;
    protected int historyMaxSize;
    protected int maxLockTime;
    protected int lockMonitorInterval;
    protected int lockBufferTime;
    protected Map threads = new HashMap();
    protected LockMonitorThread lockMonitorThread;
    protected Map monitoredJobIds = Collections.synchronizedMap(new HashMap());
    protected boolean isStarted = false;
    protected static String hostName;
    private static Log log;

    public synchronized void start() {
        if (!this.isStarted) {
            log.debug((Object)("starting thread group '" + this.name + "'..."));
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                this.startThread();
            }
            this.lockMonitorThread = new LockMonitorThread(this.jbpmConfiguration, this.lockMonitorInterval, this.maxLockTime, this.lockBufferTime);
            this.isStarted = true;
        } else {
            log.debug((Object)("ignoring start: thread group '" + this.name + "' is already started'"));
        }
    }

    public synchronized List stop() {
        ArrayList<Thread> stoppedThreads = new ArrayList<Thread>(this.threads.size());
        if (this.isStarted) {
            log.debug((Object)("stopping thread group '" + this.name + "'..."));
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                stoppedThreads.add(this.stopThread());
            }
            this.lockMonitorThread.deactivate();
            this.isStarted = false;
        } else {
            log.debug((Object)("ignoring stop: thread group '" + this.name + "' not started"));
        }
        return stoppedThreads;
    }

    public void stopAndJoin() throws InterruptedException {
        for (Thread thread : this.stop()) {
            thread.join();
        }
        this.lockMonitorThread.join();
    }

    protected synchronized void startThread() {
        String threadName = this.getNextThreadName();
        Thread thread = this.createThread(threadName);
        this.threads.put(threadName, thread);
        log.debug((Object)("starting new job executor thread '" + threadName + "'"));
        thread.start();
    }

    protected Thread createThread(String threadName) {
        return new JobExecutorThread(threadName, this, this.jbpmConfiguration, this.idleInterval, this.maxIdleInterval, this.maxLockTime, this.historyMaxSize);
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threads.size() + 1);
    }

    protected String getLastThreadName() {
        return this.getThreadName(this.threads.size());
    }

    private String getThreadName(int index) {
        return this.name + ":" + JobExecutor.getHostName() + ":" + index;
    }

    private static String getHostName() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostName = "127.0.0.1";
            }
        }
        return hostName;
    }

    protected synchronized Thread stopThread() {
        String threadName = this.getLastThreadName();
        JobExecutorThread thread = (JobExecutorThread)this.threads.remove(threadName);
        log.debug((Object)("removing job executor thread '" + threadName + "'"));
        thread.deactivate();
        return thread;
    }

    public void setMonitoredJobIds(Map monitoredJobIds) {
        this.monitoredJobIds = monitoredJobIds;
    }

    public Set getMonitoredJobIds() {
        return new HashSet(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.maxIdleInterval = maxIdleInterval;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public int getSize() {
        return this.nbrOfThreads;
    }

    public void setThreads(Map threads) {
        this.threads = threads;
    }

    public Map getThreads() {
        return this.threads;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public void setLockBufferTime(int lockBufferTime) {
        this.lockBufferTime = lockBufferTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public void setLockMonitorInterval(int lockMonitorInterval) {
        this.lockMonitorInterval = lockMonitorInterval;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    static {
        log = LogFactory.getLog(JobExecutor.class);
    }
}

