/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.util.ConfigHelper;

public class JbpmSchemaTask
extends Task {
    String config;
    String properties;
    String action;
    String output;
    String delimiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        List exceptions;
        block13: {
            if (this.action == null) {
                this.action = "create";
            }
            if (this.config == null) {
                this.config = "hibernate.cfg.xml";
            }
            exceptions = null;
            try {
                SchemaExport schemaExport;
                Configuration configuration = this.getConfiguration();
                if ("drop".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.execute(false, false, true, false);
                    exceptions = schemaExport.getExceptions();
                    break block13;
                }
                if ("create".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.execute(false, false, false, true);
                    exceptions = schemaExport.getExceptions();
                    break block13;
                }
                if ("update".equalsIgnoreCase(this.action)) {
                    PrintStream fileOut = null;
                    PrintStream systemOut = System.out;
                    try {
                        if (this.output != null) {
                            fileOut = new PrintStream(new FileOutputStream(this.output));
                            System.setOut(fileOut);
                        }
                        SchemaUpdate schemaUpdate = this.getSchemaUpdate(configuration);
                        schemaUpdate.execute(true, false);
                        exceptions = schemaUpdate.getExceptions();
                        break block13;
                    }
                    finally {
                        if (fileOut != null) {
                            System.setOut(systemOut);
                            fileOut.close();
                        }
                    }
                }
                throw new IllegalArgumentException("Unsupported action: " + this.action);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        for (Exception ex : exceptions) {
            this.log(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration getConfiguration() throws IOException {
        this.log("Action '" + this.action + "' using " + this.config + "," + this.properties);
        Configuration configuration = new Configuration();
        configuration.configure(this.config);
        if (this.properties != null) {
            InputStream inStream = ConfigHelper.getResourceAsStream((String)this.properties);
            if (inStream == null) {
                throw new IllegalArgumentException("Cannot read properties: " + this.properties);
            }
            try {
                Properties properties = new Properties();
                properties.load(inStream);
                configuration.setProperties(properties);
            }
            finally {
                inStream.close();
            }
        }
        return configuration;
    }

    private SchemaExport getSchemaExport(Configuration configuration) {
        SchemaExport schemaExport = new SchemaExport(configuration);
        if (this.output != null) {
            schemaExport.setOutputFile(this.output);
        }
        if (this.delimiter != null) {
            schemaExport.setDelimiter(this.delimiter);
        }
        schemaExport.setFormat(false);
        return schemaExport;
    }

    private SchemaUpdate getSchemaUpdate(Configuration configuration) {
        SchemaUpdate schemaUpdate = new SchemaUpdate(configuration);
        return schemaUpdate;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

