/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.svc.Services;

public class JobExecutorThread
extends Thread {
    final JobExecutor jobExecutor;
    final JbpmConfiguration jbpmConfiguration;
    final int idleInterval;
    final int maxIdleInterval;
    final long maxLockTime;
    int currentIdleInterval;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog(JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jbpmConfiguration;
        this.idleInterval = idleInterval;
        this.maxIdleInterval = maxIdleInterval;
        this.maxLockTime = maxLockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.currentIdleInterval = this.idleInterval;
        while (this.isActive) {
            try {
                long waitPeriod;
                Collection acquiredJobs = this.acquireJobs();
                if (!acquiredJobs.isEmpty()) {
                    Iterator iter = acquiredJobs.iterator();
                    while (iter.hasNext() && this.isActive) {
                        Job job = (Job)iter.next();
                        this.executeJob(job);
                    }
                } else if (this.isActive && (waitPeriod = this.getWaitPeriod()) > 0L) {
                    JobExecutor jobExecutor = this.jobExecutor;
                    synchronized (jobExecutor) {
                        this.jobExecutor.wait(waitPeriod);
                    }
                }
                this.currentIdleInterval = this.idleInterval;
            }
            catch (InterruptedException e) {
                log.info((Object)((this.isActive ? "active" : "inactive") + " job executor thread '" + this.getName() + "' got interrupted"));
            }
            catch (Exception e) {
                log.error((Object)("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds"), (Throwable)e);
                try {
                    JobExecutor waitPeriod = this.jobExecutor;
                    synchronized (waitPeriod) {
                        this.jobExecutor.wait(this.currentIdleInterval);
                    }
                }
                catch (InterruptedException e2) {
                    log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                }
                this.currentIdleInterval <<= 1;
                if (this.currentIdleInterval <= this.maxIdleInterval && this.currentIdleInterval >= 0) continue;
                this.currentIdleInterval = this.maxIdleInterval;
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection acquireJobs() {
        List<Job> acquiredJobs;
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            JbpmContext jbpmContext;
            List<Job> jobsToLock;
            block15: {
                log.debug((Object)"acquiring jobs for execution...");
                jobsToLock = Collections.EMPTY_LIST;
                jbpmContext = this.jbpmConfiguration.createJbpmContext();
                try {
                    JobSession jobSession = jbpmContext.getJobSession();
                    String lockOwner = this.getName();
                    log.debug((Object)"querying for acquirable job...");
                    Job job2 = jobSession.getFirstAcquirableJob(lockOwner);
                    if (job2 != null) {
                        if (job2.isExclusive()) {
                            log.debug((Object)("found exclusive " + job2));
                            ProcessInstance processInstance = job2.getProcessInstance();
                            log.debug((Object)("finding other exclusive jobs for " + processInstance));
                            jobsToLock = jobSession.findExclusiveJobs(lockOwner, processInstance);
                            log.debug((Object)("trying to obtain exclusive locks on " + jobsToLock + " for " + processInstance));
                        } else {
                            log.debug((Object)("trying to obtain lock on " + job2));
                            jobsToLock = Collections.singletonList(job2);
                        }
                        Date lockTime = new Date();
                        for (Job job2 : jobsToLock) {
                            job2.setLockOwner(lockOwner);
                            job2.setLockTime(lockTime);
                        }
                        break block15;
                    }
                    log.debug((Object)"no acquirable jobs in job table");
                }
                catch (Throwable throwable) {
                    block16: {
                        try {
                            jbpmContext.close();
                            List<Job> acquiredJobs2 = jobsToLock;
                            log.debug((Object)("obtained lock on jobs: " + acquiredJobs2));
                        }
                        catch (JbpmPersistenceException e) {
                            if (Services.isCausedByStaleState(e)) {
                                log.debug((Object)("optimistic locking failed, couldn't obtain lock on jobs " + jobsToLock));
                                List acquiredJobs2 = Collections.EMPTY_LIST;
                                break block16;
                            }
                            throw e;
                        }
                    }
                    throw throwable;
                }
            }
            try {
                jbpmContext.close();
                acquiredJobs = jobsToLock;
                log.debug((Object)("obtained lock on jobs: " + acquiredJobs));
            }
            catch (JbpmPersistenceException e) {
                if (Services.isCausedByStaleState(e)) {
                    log.debug((Object)("optimistic locking failed, couldn't obtain lock on jobs " + jobsToLock));
                    acquiredJobs = Collections.EMPTY_LIST;
                }
                throw e;
            }
        }
        return acquiredJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(Job job) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            job = jobSession.loadJob(job.getId());
            jbpmContext.addAutoSaveProcessInstance(job.getProcessInstance());
            log.debug((Object)("executing " + job));
            try {
                if (job.execute(jbpmContext)) {
                    jobSession.deleteJob(job);
                }
            }
            catch (Exception e) {
                log.debug((Object)("exception while executing " + job), (Throwable)e);
                if (!JobExecutorThread.isPersistenceException(e)) {
                    StringWriter memoryWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter(memoryWriter));
                    job.setException(memoryWriter.toString());
                    job.setRetries(job.getRetries() - 1);
                }
                jbpmContext.setRollbackOnly();
            }
            long totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime();
            if (totalLockTimeInMillis > this.maxLockTime) {
                jbpmContext.setRollbackOnly();
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if (Services.isCausedByStaleState(e)) {
                    log.debug((Object)("optimistic locking failed, couldn't complete job " + job));
                }
                throw e;
            }
        }
    }

    private static boolean isPersistenceException(Throwable throwable) {
        do {
            if (!(throwable instanceof HibernateException)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Set jobIdsToIgnore = this.jobExecutor.getMonitoredJobIds();
            Job job = jobSession.getFirstDueJob(this.getName(), jobIdsToIgnore);
            if (job != null) {
                nextDueDate = job.getDueDate();
                this.jobExecutor.addMonitoredJobId(this.getName(), job.getId());
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if (Services.isCausedByStaleState(e)) {
                    log.debug((Object)"optimistic locking failed, couldn't get next due date");
                    nextDueDate = null;
                }
                throw e;
            }
        }
        return nextDueDate;
    }

    protected long getWaitPeriod() {
        long interval = this.currentIdleInterval;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTime = System.currentTimeMillis();
            long nextDueTime = nextDueDate.getTime();
            if (nextDueTime < currentTime + (long)this.currentIdleInterval) {
                interval = nextDueTime - currentTime;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

