/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.svc.Services;

public class LockMonitorThread
extends Thread {
    JbpmConfiguration jbpmConfiguration;
    int lockMonitorInterval;
    int maxLockTime;
    int lockBufferTime;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog(LockMonitorThread.class);

    public LockMonitorThread(JbpmConfiguration jbpmConfiguration, int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.jbpmConfiguration = jbpmConfiguration;
        this.lockMonitorInterval = lockMonitorInterval;
        this.maxLockTime = maxLockTime;
        this.lockBufferTime = lockBufferTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.isActive) {
                try {
                    this.unlockOverdueJobs();
                    if (!this.isActive || this.lockMonitorInterval <= 0) continue;
                    LockMonitorThread.sleep(this.lockMonitorInterval);
                }
                catch (InterruptedException e) {
                    log.info((Object)("lock monitor thread '" + this.getName() + "' got interrupted"));
                }
                catch (Exception e) {
                    log.error((Object)("exception in lock monitor thread. waiting " + this.lockMonitorInterval + " milliseconds"), (Throwable)e);
                    try {
                        LockMonitorThread.sleep(this.lockMonitorInterval);
                    }
                    catch (InterruptedException e2) {
                        log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)"exception in lock monitor thread", (Throwable)e);
            return;
        }
        finally {
            log.info((Object)(this.getName() + " leaves cyberspace"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockOverdueJobs() {
        List<Job> overdueJobs = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            Date threshold = new Date(System.currentTimeMillis() - (long)this.maxLockTime - (long)this.lockBufferTime);
            JobSession jobSession = jbpmContext.getJobSession();
            overdueJobs = jobSession.findJobsWithOverdueLockTime(threshold);
            for (Job job : overdueJobs) {
                log.debug((Object)("unlocking " + job + " owned by thread " + job.getLockOwner()));
                job.setLockOwner(null);
                job.setLockTime(null);
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if (Services.isCausedByStaleState(e)) {
                    log.debug((Object)("optimistic locking failed, could not unlock overdue jobs: " + overdueJobs));
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)"problem unlocking overdue jobs: optimistic locking failed", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

