package org.jbpm.jpdl.el.impl;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.ExpressionEvaluator;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.FunctionMapper;

public class JbpmExpressionEvaluator {

  private static ExpressionEvaluator expressionEvaluator;

  static ExpressionEvaluator getExpressionEvaluator() {
    return expressionEvaluator != null ? expressionEvaluator
        : (ExpressionEvaluator) JbpmConfiguration.Configs.getObject("jbpm.expression.evaluator");
  }

  /** @deprecated Use the configuration entry <code>jbpm.expression.evaluator</code> instead */
  public static void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
    JbpmExpressionEvaluator.expressionEvaluator = expressionEvaluator;
  }

  static VariableResolver variableResolver;

  /** @deprecated Use the configuration entry <code>jbpm.variable.resolver</code> instead */
  public static void setVariableResolver(VariableResolver variableResolver) {
    JbpmExpressionEvaluator.variableResolver = variableResolver;
  }

  static FunctionMapper functionMapper;

  /** @deprecated Use the configuration entry <code>jbpm.function.mapper</code> instead */
  public static void setFunctionMapper(FunctionMapper functionMapper) {
    JbpmExpressionEvaluator.functionMapper = functionMapper;
  }

  public static Object evaluate(String expression, ExecutionContext executionContext) {
    return evaluate(expression, executionContext, getVariableResolver(), getFunctionMapper());
  }

  public static Object evaluate(String expression, ExecutionContext executionContext,
      VariableResolver variableResolver, FunctionMapper functionMapper) {
    ExecutionContext.pushCurrentContext(executionContext);
    try {
      String dollarExpression = translateExpressionToDollars(expression);
      return getExpressionEvaluator().evaluate(dollarExpression, Object.class,
          variableResolver, functionMapper);
    }
    catch (ELException e) {
      throw new JbpmException("couldn't evaluate expression '" + expression + "'",
          e.getRootCause() != null ? e.getRootCause() : e);
    }
    finally {
      ExecutionContext.popCurrentContext(executionContext);
    }
  }

  static String translateExpressionToDollars(String expression) {
    int hashIndex = expression.indexOf("#{");
    if (hashIndex == -1) return expression;
    
    char[] expressionChars = expression.toCharArray();
    do {
      expressionChars[hashIndex] = '$';
      hashIndex = expression.indexOf("#{", hashIndex + 2);
    } while (hashIndex != -1);
    return new String(expressionChars);
  }

  /** @deprecated Use {@link #getVariableResolver()} instead */
  public static VariableResolver getUsedVariableResolver() {
    return getVariableResolver();
  }

  public static VariableResolver getVariableResolver() {
    return variableResolver != null ? variableResolver
        : (VariableResolver) JbpmConfiguration.Configs.getObject("jbpm.variable.resolver");
  }

  /** @deprecated Use {@link #getFunctionMapper()} instead */
  public static FunctionMapper getUsedFunctionMapper() {
    return getFunctionMapper();
  }

  public static FunctionMapper getFunctionMapper() {
    return functionMapper != null ? functionMapper
        : JbpmConfiguration.Configs.hasObject("jbpm.function.mapper") ?
            (FunctionMapper) JbpmConfiguration.Configs.getObject("jbpm.function.mapper")
            : null;
  }
}
