/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.BooleanInfo;
import org.jbpm.configuration.CharacterInfo;
import org.jbpm.configuration.DoubleInfo;
import org.jbpm.configuration.FloatInfo;
import org.jbpm.configuration.IntegerInfo;
import org.jbpm.configuration.JbpmContextInfo;
import org.jbpm.configuration.JbpmTypeObjectInfo;
import org.jbpm.configuration.ListInfo;
import org.jbpm.configuration.LongInfo;
import org.jbpm.configuration.MapInfo;
import org.jbpm.configuration.NullInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.configuration.RefInfo;
import org.jbpm.configuration.StringInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ObjectFactoryParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Map defaultMappings;
    private static final Class[] constructorParameterTypes;
    private Map mappings;
    private Map namedObjectInfos;

    public static Map getDefaultMappings() {
        if (defaultMappings == null) {
            defaultMappings = new HashMap();
            ObjectFactoryParser.addMapping(defaultMappings, "bean", BeanInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "ref", RefInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "list", ListInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "map", MapInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "string", StringInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "int", IntegerInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "integer", IntegerInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "long", LongInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "float", FloatInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "double", DoubleInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "char", CharacterInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "character", CharacterInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "boolean", BooleanInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "true", BooleanInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "false", BooleanInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "null", NullInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "jbpm-context", JbpmContextInfo.class);
            ObjectFactoryParser.addMapping(defaultMappings, "jbpm-type", JbpmTypeObjectInfo.class);
        }
        return defaultMappings;
    }

    private static void addMapping(Map mappings, String elementTagName, Class objectInfoClass) {
        try {
            Constructor constructor = objectInfoClass.getDeclaredConstructor(constructorParameterTypes);
            mappings.put(elementTagName, constructor);
        }
        catch (NoSuchMethodException e) {
            throw new JbpmException("couldn't add mapping for element '" + elementTagName + "': constructor(" + Element.class.getName() + "," + ObjectFactoryParser.class.getName() + ") was missing for class '" + objectInfoClass.getName() + "'", e);
        }
    }

    public static ObjectFactoryImpl parseXmlString(String xml) {
        Element rootElement = XmlUtil.parseXmlText(xml).getDocumentElement();
        return ObjectFactoryParser.createObjectFactory(rootElement);
    }

    public static ObjectFactoryImpl parseInputStream(InputStream xmlInputStream) {
        Element rootElement = XmlUtil.parseXmlInputStream(xmlInputStream).getDocumentElement();
        return ObjectFactoryParser.createObjectFactory(rootElement);
    }

    public static ObjectFactoryImpl parseResource(String resource) {
        Element rootElement = XmlUtil.parseXmlResource(resource, false).getDocumentElement();
        return ObjectFactoryParser.createObjectFactory(rootElement);
    }

    public static ObjectFactoryImpl createObjectFactory(Element rootElement) {
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ArrayList<ObjectInfo> objectInfos = new ArrayList<ObjectInfo>();
        Iterator iter = XmlUtil.elementIterator(rootElement);
        while (iter.hasNext()) {
            Element topLevelElement = (Element)iter.next();
            ObjectInfo objectInfo = objectFactoryParser.parse(topLevelElement);
            objectInfos.add(objectInfo);
        }
        return new ObjectFactoryImpl(objectFactoryParser.namedObjectInfos, objectInfos);
    }

    public void parseElementsFromResource(String resource, ObjectFactoryImpl objectFactoryImpl) {
        Element rootElement = XmlUtil.parseXmlResource(resource, false).getDocumentElement();
        this.parseElements(rootElement, objectFactoryImpl);
    }

    public void parseElementsStream(InputStream inputStream, ObjectFactoryImpl objectFactoryImpl) {
        Element rootElement = XmlUtil.parseXmlInputStream(inputStream).getDocumentElement();
        this.parseElements(rootElement, objectFactoryImpl);
    }

    public void parseElements(Element element, ObjectFactoryImpl objectFactoryImpl) {
        Iterator iter = XmlUtil.elementIterator(element);
        while (iter.hasNext()) {
            Element objectInfoElement = (Element)iter.next();
            ObjectInfo objectInfo = this.parse(objectInfoElement);
            objectFactoryImpl.addObjectInfo(objectInfo);
        }
    }

    public ObjectFactoryParser() {
        this(ObjectFactoryParser.getDefaultMappings());
    }

    public ObjectFactoryParser(Map mappings) {
        this.mappings = mappings;
        this.namedObjectInfos = new HashMap();
    }

    public ObjectInfo parse(Element element) {
        String tagName = element.getTagName().toLowerCase();
        Constructor constructor = (Constructor)this.mappings.get(tagName);
        if (constructor == null) {
            throw new JbpmException("no ObjectInfo class specified for element: " + tagName);
        }
        try {
            return (ObjectInfo)constructor.newInstance(element, this);
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + constructor, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException(constructor + " threw exception", e);
        }
    }

    public void addNamedObjectInfo(String name, ObjectInfo objectInfo) {
        this.namedObjectInfos.put(name, objectInfo);
    }

    public void addMapping(String elementName, Class objectInfoClass) {
        if (this.mappings == ObjectFactoryParser.getDefaultMappings()) {
            this.mappings = new HashMap(ObjectFactoryParser.getDefaultMappings());
        }
        ObjectFactoryParser.addMapping(this.mappings, elementName, objectInfoClass);
    }

    static {
        constructorParameterTypes = new Class[]{Element.class, ObjectFactoryParser.class};
    }
}

