/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.variableinstance;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.jcr.JcrService;
import org.jbpm.svc.Service;
import org.jbpm.svc.Services;

public class JcrNodeInstance
extends VariableInstance {
    private static final long serialVersionUID = 1L;
    String repository;
    String workspace;
    String path;
    private static final Log log = LogFactory.getLog((Class)JcrNodeInstance.class);

    public boolean isStorable(Object value) {
        if (value == null) {
            return true;
        }
        return Node.class.isAssignableFrom(value.getClass());
    }

    protected Object getObject() {
        if (this.path == null) {
            return null;
        }
        JcrService jcrService = this.findService();
        if (jcrService == null) {
            throw new JbpmException("couldn't find jBPM service for JCR repository '" + this.repository + "', workspace '" + this.workspace + "'");
        }
        try {
            return jcrService.getSession().getItem(this.path);
        }
        catch (PathNotFoundException e) {
            throw new JbpmException("failed to get item from path: " + this.path, e);
        }
        catch (RepositoryException e) {
            throw new JbpmException("failed to get item from path: " + this.path, e);
        }
    }

    private JcrService findService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        Services services = jbpmContext.getServices();
        Service service = services.getService("jcr");
        if (service != null) {
            return (JcrService)service;
        }
        String serviceName = null;
        Iterator iter = services.getServiceFactories().keySet().iterator();
        while (iter.hasNext()) {
            String candidate = (String)iter.next();
            if (!candidate.startsWith(this.repository)) continue;
            if (candidate.length() == this.repository.length()) {
                if (serviceName != null) continue;
                serviceName = candidate;
                continue;
            }
            if (!candidate.endsWith(this.workspace)) continue;
            serviceName = candidate;
            break;
        }
        if (serviceName == null) {
            throw new JbpmException("could not find JCR service for repository '" + this.repository + "' and workspace '" + this.workspace + '\'');
        }
        return (JcrService)services.getService(serviceName);
    }

    protected void setObject(Object value) {
        Node node = (Node)value;
        if (value == null) {
            this.repository = null;
            this.workspace = null;
            this.path = null;
        } else {
            try {
                Session session = node.getSession();
                this.repository = session.getRepository().getDescriptor("jcr.repository.name");
                this.workspace = session.getWorkspace().getName();
                this.path = node.getPath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("stored jcr node, repository '" + this.repository + "', workspace '" + this.workspace + "' and path'" + this.path + '\''));
                }
            }
            catch (RepositoryException e) {
                throw new JbpmException("problem storing JCR node '" + node + "' in the process variable '" + this.name + "'", e);
            }
        }
    }
}

