/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.JpdlException;

public class DbSubProcessResolver
implements SubProcessResolver {
    private static final long serialVersionUID = 1L;

    public ProcessDefinition findSubProcess(Element subProcessElement) {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            GraphSession graphSession = jbpmContext.getGraphSession();
            String subProcessName = subProcessElement.attributeValue("name");
            if (subProcessName == null) {
                throw new JpdlException("subprocess name is not specified: " + subProcessElement.getPath());
            }
            String subProcessVersion = subProcessElement.attributeValue("version");
            if (subProcessVersion == null) {
                return graphSession.findLatestProcessDefinition(subProcessName);
            }
            try {
                int version = Integer.parseInt(subProcessVersion);
                return graphSession.findProcessDefinition(subProcessName, version);
            }
            catch (NumberFormatException e) {
                throw new JpdlException("bad subprocess version: " + subProcessVersion);
            }
        }
        return null;
    }
}

