/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread {
    private final JobExecutor jobExecutor;
    private volatile boolean isActive = true;
    private final Random random = new Random();
    private static final Log log = LogFactory.getLog((Class)JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int currentIdleInterval = this.jobExecutor.getIdleInterval();
        while (this.isActive) {
            Collection acquiredJobs = this.acquireJobs();
            boolean success = true;
            Iterator i = acquiredJobs.iterator();
            while (i.hasNext() && this.isActive) {
                Job job = (Job)i.next();
                try {
                    this.executeJob(job);
                }
                catch (Exception e) {
                    this.saveJobException(job, e);
                    success = false;
                    break;
                }
            }
            if (!this.isActive) continue;
            try {
                if (success) {
                    currentIdleInterval = this.jobExecutor.getIdleInterval();
                    long waitPeriod = this.getWaitPeriod(currentIdleInterval);
                    if (waitPeriod <= 0L) continue;
                    JobExecutor jobExecutor = this.jobExecutor;
                    synchronized (jobExecutor) {
                        this.jobExecutor.wait(waitPeriod);
                        continue;
                    }
                }
                int waitPeriod = currentIdleInterval / 2;
                JobExecutorThread.sleep(waitPeriod + this.random.nextInt(waitPeriod));
                int maxIdleInterval = this.jobExecutor.getMaxIdleInterval();
                if ((currentIdleInterval *= 2) <= maxIdleInterval && currentIdleInterval >= 0) continue;
                currentIdleInterval = maxIdleInterval;
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(this.getName() + " got interrupted"));
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection acquireJobs() {
        List jobs;
        boolean debug = log.isDebugEnabled();
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
            try {
                String lockOwner = this.getName();
                JobSession jobSession = jbpmContext.getJobSession();
                Job firstJob = jobSession.getFirstAcquirableJob(lockOwner);
                if (firstJob != null) {
                    if (firstJob.isExclusive()) {
                        ProcessInstance processInstance = firstJob.getProcessInstance();
                        jobs = jobSession.findExclusiveJobs(lockOwner, processInstance);
                        if (debug) {
                            log.debug((Object)("acquiring exclusive " + jobs + " for " + processInstance));
                        }
                    } else {
                        jobs = Collections.singletonList(firstJob);
                        if (debug) {
                            log.debug((Object)("acquiring " + firstJob));
                        }
                    }
                    Date lockTime = new Date();
                    Iterator i = jobs.iterator();
                    while (i.hasNext()) {
                        Job job = (Job)i.next();
                        job.setLockOwner(lockOwner);
                        job.setLockTime(lockTime);
                        if (job.getException() == null) continue;
                        int retries = job.getRetries() - 1;
                        job.setRetries(retries);
                        if (!debug) continue;
                        log.debug((Object)(job + " has " + retries + " retries remaining"));
                    }
                    if (debug) {
                        log.debug((Object)("acquired " + jobs));
                    }
                } else {
                    jobs = Collections.EMPTY_LIST;
                    if (debug) {
                        log.debug((Object)"no acquirable job found");
                    }
                }
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                jobs = Collections.EMPTY_LIST;
                if (debug) {
                    log.debug((Object)"failed to acquire jobs", (Throwable)e);
                }
            }
            catch (Error e) {
                jbpmContext.setRollbackOnly();
                throw e;
            }
            finally {
                block27: {
                    try {
                        jbpmContext.close();
                    }
                    catch (RuntimeException e) {
                        jobs = Collections.EMPTY_LIST;
                        if (!debug) break block27;
                        log.debug((Object)"failed to acquire jobs", (Throwable)e);
                    }
                }
            }
        }
        return jobs;
    }

    protected void executeJob(Job job) throws Exception {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            jobSession.reattachJob(job);
            jbpmContext.addAutoSaveProcessInstance(job.getProcessInstance());
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing " + job));
            }
            if (job.execute(jbpmContext)) {
                jobSession.deleteJob(job);
            }
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    private void saveJobException(Job job, Exception exception) {
        if (DbPersistenceService.isLockingException(exception)) {
            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to execute " + job), (Throwable)exception);
        } else {
            log.error((Object)("failed to execute " + job), (Throwable)exception);
        }
        boolean debug = log.isDebugEnabled();
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            job = jobSession.loadJob(job.getId());
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            job.setException(out.toString());
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (debug) {
                log.debug((Object)"failed to save job exception", (Throwable)e);
            }
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            block17: {
                try {
                    jbpmContext.close();
                }
                catch (RuntimeException e) {
                    if (!debug) break block17;
                    log.debug((Object)"failed to save job exception", (Throwable)e);
                }
            }
        }
    }

    protected long getWaitPeriod(int currentIdleInterval) {
        long waitPeriod;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null && (waitPeriod = nextDueDate.getTime() - System.currentTimeMillis()) < (long)currentIdleInterval) {
            return waitPeriod;
        }
        return currentIdleInterval;
    }

    protected Date getNextDueDate() {
        Date nextDueDate;
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            String lockOwner = this.getName();
            Job job = jbpmContext.getJobSession().getFirstDueJob(lockOwner, this.jobExecutor.getMonitoredJobIds());
            if (job != null) {
                this.jobExecutor.addMonitoredJobId(lockOwner, job.getId());
                nextDueDate = job.getDueDate();
            } else {
                nextDueDate = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"no due job found");
                }
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            nextDueDate = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"failed to determine next due date", (Throwable)e);
            }
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            block18: {
                try {
                    jbpmContext.close();
                }
                catch (RuntimeException e) {
                    nextDueDate = null;
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)"failed to determine next due date", (Throwable)e);
                }
            }
        }
        return nextDueDate;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

