/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.mail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.mail.AddressResolver;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Mail
implements ActionHandler {
    private String template;
    private String to;
    private String actors;
    private String cc;
    private String ccActors;
    private String bcc;
    private String bccActors;
    private String subject;
    private String text;
    private ExecutionContext executionContext;
    private static final long serialVersionUID = 2L;
    private static final Map serverPropertiesByResource = new HashMap();
    private static final Map templatePropertiesByResource = new HashMap();
    private static final Map templateVariablesByResource = new HashMap();
    private static final Log log = LogFactory.getLog((Class)Mail.class);

    public Mail() {
    }

    public Mail(String template, String actors, String to, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.subject = subject;
        this.text = text;
    }

    public Mail(String template, String actors, String to, String bccActors, String bcc, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.bccActors = bccActors;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
    }

    public void execute(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.send();
    }

    public List getRecipients() {
        ArrayList recipients = new ArrayList();
        if (this.actors != null) {
            recipients.addAll(this.evaluateActors(this.actors));
        }
        if (this.to != null) {
            recipients.addAll(this.evaluateAddresses(this.to));
        }
        return recipients;
    }

    public List getCcRecipients() {
        ArrayList recipients = new ArrayList();
        if (this.ccActors != null) {
            recipients.addAll(this.evaluateActors(this.ccActors));
        }
        if (this.cc != null) {
            recipients.addAll(this.evaluateAddresses(this.cc));
        }
        return recipients;
    }

    public List getBccRecipients() {
        ArrayList recipients = new ArrayList();
        if (this.bccActors != null) {
            recipients.addAll(this.evaluateActors(this.bccActors));
        }
        if (this.bcc != null) {
            recipients.addAll(this.evaluateAddresses(this.bcc));
        }
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.bcc.address")) {
            recipients.addAll(this.tokenize(JbpmConfiguration.Configs.getString("jbpm.mail.bcc.address")));
        }
        return recipients;
    }

    private Collection evaluateActors(String expression) {
        ArrayList actors;
        Object value = this.evaluate(expression, Object.class);
        if (value instanceof String) {
            actors = this.tokenize((String)value);
        } else if (value instanceof String[]) {
            actors = Arrays.asList((String[])value);
        } else if (value instanceof List) {
            actors = (ArrayList)value;
        } else if (value instanceof Collection) {
            actors = new ArrayList((Collection)value);
        } else {
            throw new JbpmException("could not resolve actors from expression: " + expression);
        }
        return this.resolveAddresses(actors);
    }

    protected Collection resolveAddresses(List actorIds) {
        AddressResolver addressResolver = (AddressResolver)JbpmConfiguration.Configs.getObject("jbpm.mail.address.resolver");
        ArrayList<Object> addresses = new ArrayList<Object>();
        Iterator iter = actorIds.iterator();
        while (iter.hasNext()) {
            String actorId = (String)iter.next();
            Object result = addressResolver.resolveAddress(actorId);
            if (result instanceof String) {
                addresses.add(result);
                continue;
            }
            if (result instanceof Collection) {
                addresses.addAll((Collection)result);
                continue;
            }
            if (result instanceof String[]) {
                addresses.addAll(Arrays.asList((String[])result));
                continue;
            }
            if (result == null) continue;
            throw new JbpmException(addressResolver + " returned " + result + " instead of single string, string array or collection");
        }
        return addresses;
    }

    private Collection evaluateAddresses(String expression) {
        Object value = this.evaluate(expression, Object.class);
        if (value instanceof String) {
            return this.tokenize((String)value);
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        throw new JbpmException(expression + " returned " + value + " instead of comma-separated string, string array or collection");
    }

    protected List tokenize(String text) {
        return text != null ? Arrays.asList(text.split("[,;:]+")) : null;
    }

    private Object evaluate(String expression, Class expectedType) {
        MailVariableResolver variableResolver = new MailVariableResolver(Mail.getTemplateVariables(), JbpmExpressionEvaluator.getVariableResolver());
        return JbpmExpressionEvaluator.evaluate(expression, this.executionContext, expectedType, variableResolver, JbpmExpressionEvaluator.getFunctionMapper());
    }

    public String getSubject() {
        return this.subject != null ? (String)this.evaluate(this.subject, String.class) : null;
    }

    public String getText() {
        return this.text != null ? (String)this.evaluate(this.text, String.class) : null;
    }

    public String getFromAddress() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.from.address")) {
            return JbpmConfiguration.Configs.getString("jbpm.mail.from.address");
        }
        return "no-reply@jbpm.org";
    }

    public void send() {
        if (this.template != null) {
            Properties templateProperties = Mail.getTemplateProperties(this.template);
            if (this.actors == null) {
                this.actors = templateProperties.getProperty("actors");
            }
            if (this.to == null) {
                this.to = templateProperties.getProperty("to");
            }
            if (this.cc == null) {
                this.cc = templateProperties.getProperty("cc");
            }
            if (this.ccActors == null) {
                this.ccActors = templateProperties.getProperty("cc-actors");
            }
            if (this.bcc == null) {
                this.bcc = templateProperties.getProperty("bcc");
            }
            if (this.bccActors == null) {
                this.bccActors = templateProperties.getProperty("bcc-actors");
            }
            if (this.subject == null) {
                this.subject = templateProperties.getProperty("subject");
            }
            if (this.text == null) {
                this.text = templateProperties.getProperty("text");
            }
        }
        List recipients = this.getRecipients();
        List ccRecipients = this.getCcRecipients();
        List bccRecipients = this.getBccRecipients();
        if (recipients.isEmpty() && ccRecipients.isEmpty() && bccRecipients.isEmpty()) {
            return;
        }
        String subject = this.getSubject();
        String text = this.getText();
        if (log.isDebugEnabled()) {
            StringBuffer detail = new StringBuffer("sending email to ");
            detail.append(recipients);
            if (!ccRecipients.isEmpty()) {
                detail.append(" cc ").append(ccRecipients);
            }
            if (!bccRecipients.isEmpty()) {
                detail.append(" bcc ").append(bccRecipients);
            }
            if (subject != null) {
                detail.append(" about '").append(subject).append('\'');
            }
            log.debug((Object)detail.toString());
        }
        Session session = Session.getInstance((Properties)this.getServerProperties());
        for (int retries = 3; retries >= 0; --retries) {
            try {
                Mail.sendMailInternal(session, recipients, ccRecipients, bccRecipients, subject, text);
                break;
            }
            catch (MessagingException me) {
                if (retries == 0) {
                    throw new JbpmException("cannot send email", me);
                }
                log.warn((Object)("cannot send mail (" + retries + " retries left): " + me.getMessage()));
                continue;
            }
        }
    }

    public static void send(Properties serverProperties, String fromAddress, List recipients, String subject, String text) {
        Mail.send(serverProperties, fromAddress, recipients, Collections.EMPTY_LIST, subject, text);
    }

    public static void send(Properties serverProperties, String fromAddress, List recipients, List bccRecipients, String subject, String text) {
        if (recipients.isEmpty() && bccRecipients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            StringBuffer detail = new StringBuffer("sending email to ");
            detail.append(recipients);
            if (bccRecipients != null) {
                detail.append(" bcc ").append(bccRecipients);
            }
            if (subject != null) {
                detail.append(" about '").append(subject).append('\'');
            }
            log.debug((Object)detail.toString());
        }
        Session session = Session.getInstance((Properties)serverProperties);
        for (int retries = 3; retries >= 0; --retries) {
            try {
                Mail.sendMailInternal(session, recipients, null, bccRecipients, subject, text);
                break;
            }
            catch (MessagingException me) {
                if (retries == 0) {
                    throw new JbpmException("cannot send email", me);
                }
                log.warn((Object)("cannot send mail (" + retries + " retries left): " + me.getMessage()));
                continue;
            }
        }
    }

    private static void sendMailInternal(Session session, List recipients, List ccRecipients, List bccRecipients, String subject, String text) throws MessagingException {
        InternetAddress recipient;
        MimeMessage message = new MimeMessage(session);
        Iterator iter = recipients.iterator();
        while (iter.hasNext()) {
            recipient = new InternetAddress((String)iter.next());
            message.addRecipient(Message.RecipientType.TO, (Address)recipient);
        }
        if (ccRecipients != null) {
            iter = ccRecipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.CC, (Address)recipient);
            }
        }
        if (bccRecipients != null) {
            iter = bccRecipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.BCC, (Address)recipient);
            }
        }
        if (subject != null) {
            message.setSubject(subject);
        }
        if (text != null) {
            message.setText(text);
        }
        Transport.send((Message)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getServerProperties() {
        Properties serverProperties;
        if (JbpmConfiguration.Configs.hasObject("resource.mail.properties")) {
            String resource = JbpmConfiguration.Configs.getString("resource.mail.properties");
            Map map = serverPropertiesByResource;
            synchronized (map) {
                serverProperties = (Properties)serverPropertiesByResource.get(resource);
                if (serverProperties == null) {
                    serverProperties = ClassLoaderUtil.getProperties(resource);
                    serverPropertiesByResource.put(resource, serverProperties);
                }
            }
        } else {
            serverProperties = new Properties();
            if (JbpmConfiguration.Configs.hasObject("jbpm.mail.smtp.host")) {
                String smtpHost = JbpmConfiguration.Configs.getString("jbpm.mail.smtp.host");
                serverProperties.setProperty("mail.smtp.host", smtpHost);
            }
            if (JbpmConfiguration.Configs.hasObject("jbpm.mail.smtp.port")) {
                int port = JbpmConfiguration.Configs.getInt("jbpm.mail.smtp.port");
                serverProperties.setProperty("mail.smtp.port", Integer.toString(port));
            }
            String from = this.getFromAddress();
            serverProperties.setProperty("mail.from", from);
        }
        return serverProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getTemplateProperties(String templateName) {
        String resource = JbpmConfiguration.Configs.getString("resource.mail.templates");
        Map map = templatePropertiesByResource;
        synchronized (map) {
            Map templateProperties = (Map)templatePropertiesByResource.get(resource);
            if (templateProperties == null) {
                Mail.loadTemplates(resource);
                templateProperties = (Map)templatePropertiesByResource.get(resource);
            }
            return (Properties)templateProperties.get(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getTemplateVariables() {
        String resource = JbpmConfiguration.Configs.getString("resource.mail.templates");
        Map map = templateVariablesByResource;
        synchronized (map) {
            Map templateVariables = (Map)templateVariablesByResource.get(resource);
            if (templateVariables == null) {
                Mail.loadTemplates(resource);
                templateVariables = (Map)templateVariablesByResource.get(resource);
            }
            return templateVariables;
        }
    }

    private static void loadTemplates(String resource) {
        Element templatesElement = XmlUtil.parseXmlResource(resource, true).getDocumentElement();
        HashMap<String, Properties> templatePropertiesMap = new HashMap<String, Properties>();
        Iterator iter = XmlUtil.elementIterator(templatesElement, "mail-template");
        while (iter.hasNext()) {
            Element templateElement = (Element)iter.next();
            Properties templateProperties = new Properties();
            Mail.addTemplateProperty(templateElement, "to", templateProperties);
            Mail.addTemplateProperty(templateElement, "actors", templateProperties);
            Mail.addTemplateProperty(templateElement, "subject", templateProperties);
            Mail.addTemplateProperty(templateElement, "text", templateProperties);
            Mail.addTemplateProperty(templateElement, "cc", templateProperties);
            Mail.addTemplateProperty(templateElement, "cc-actors", templateProperties);
            Mail.addTemplateProperty(templateElement, "bcc", templateProperties);
            Element bccActorsElement = XmlUtil.element(templateElement, "bccActors");
            if (bccActorsElement != null) {
                templateProperties.setProperty("bcc-actors", XmlUtil.getContentText(bccActorsElement));
            } else {
                Mail.addTemplateProperty(templateElement, "bcc-actors", templateProperties);
            }
            templatePropertiesMap.put(templateElement.getAttribute("name"), templateProperties);
        }
        templatePropertiesByResource.put(resource, templatePropertiesMap);
        HashMap<String, String> templateVariables = new HashMap<String, String>();
        Iterator iter2 = XmlUtil.elementIterator(templatesElement, "variable");
        while (iter2.hasNext()) {
            Element variableElement = (Element)iter2.next();
            templateVariables.put(variableElement.getAttribute("name"), variableElement.getAttribute("value"));
        }
        templateVariablesByResource.put(resource, templateVariables);
    }

    private static void addTemplateProperty(Element templateElement, String property, Properties templateProperties) {
        Element element = XmlUtil.element(templateElement, property);
        if (element != null) {
            templateProperties.setProperty(property, XmlUtil.getContentText(element));
        }
    }

    static class MailVariableResolver
    implements VariableResolver,
    Serializable {
        private Map templateVariables;
        private VariableResolver variableResolver;
        private static final long serialVersionUID = 1L;

        MailVariableResolver(Map templateVariables, VariableResolver variableResolver) {
            this.templateVariables = templateVariables;
            this.variableResolver = variableResolver;
        }

        public Object resolveVariable(String pName) throws ELException {
            if (this.templateVariables != null && this.templateVariables.containsKey(pName)) {
                return this.templateVariables.get(pName);
            }
            return this.variableResolver != null ? this.variableResolver.resolveVariable(pName) : null;
        }
    }
}

