/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.def;

import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.scheduler.SchedulerService;

public class CancelTimerAction
extends Action {
    private static final long serialVersionUID = 1L;
    String timerName;

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        this.timerName = actionElement.attributeValue("name");
        if (this.timerName == null) {
            jpdlReader.addWarning("timer name not specified on cancel timer: " + actionElement.getPath());
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        SchedulerService schedulerService = executionContext.getJbpmContext().getServices().getSchedulerService();
        schedulerService.deleteTimersByName(this.timerName, executionContext.getToken());
    }

    public String toString() {
        return "CancelTimerAction(" + this.timerName + ')';
    }

    public String getTimerName() {
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }
}

