/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseId;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LoadProcessInstanceActionListener
implements JbpmActionListener {
    private final ValueExpression idExpression;
    private final ValueExpression targetExpression;
    private final ValueExpression forUpdateExpression;

    public LoadProcessInstanceActionListener(ValueExpression idExpression, ValueExpression targetExpression, ValueExpression forUpdateExpression) {
        this.idExpression = idExpression;
        this.targetExpression = targetExpression;
        this.forUpdateExpression = forUpdateExpression;
    }

    public String getName() {
        return "loadProcessInstance";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            boolean forUpdate;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.idExpression.getValue(elContext);
            if (idValue == null) {
                context.setError("Error loading process instance", "The ID value is null");
                return;
            }
            long id = idValue instanceof Long ? ((Long)idValue).longValue() : Long.valueOf(idValue.toString()).longValue();
            if (this.forUpdateExpression != null) {
                Object forUpdateValue = this.forUpdateExpression.getValue(elContext);
                if (forUpdateValue == null) {
                    context.setError("Error loading process instance", "The value of 'forUpdate' is null");
                    return;
                }
                forUpdate = forUpdateValue instanceof Boolean ? (Boolean)forUpdateValue : Boolean.parseBoolean(forUpdateValue.toString());
            } else {
                forUpdate = event.getPhaseId() != PhaseId.RENDER_RESPONSE;
            }
            ProcessInstance processInstance = forUpdate ? context.getJbpmContext().getProcessInstanceForUpdate(id) : context.getJbpmContext().getProcessInstance(id);
            if (processInstance == null) {
                context.setError("Error loading process instance", "No process instance was found with an ID of " + id);
                return;
            }
            this.targetExpression.setValue(elContext, (Object)processInstance);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading process instance", ex);
            return;
        }
    }
}

