/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private JbpmConfiguration jbpmConfiguration;
    private static final Log log = LogFactory.getLog(ProcessUploadServlet.class);

    public void init() throws ServletException {
        String jbpmCfgResource = this.getServletContext().getInitParameter("jbpm.configuration.resource");
        this.jbpmConfiguration = JbpmConfiguration.getInstance((String)jbpmCfgResource);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"Handling status request");
        response.getWriter().println("Process upload module is operational");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"Handling upload request");
        response.getWriter().println(this.handleRequest(request));
    }

    private String handleRequest(HttpServletRequest request) {
        FileItem fileItem;
        block8: {
            List itemList;
            block7: {
                if (!FileUpload.isMultipartContent((HttpServletRequest)request)) {
                    log.debug((Object)"Not a multipart request");
                    return "Not a multipart request";
                }
                try {
                    DiskFileUpload fileUpload = new DiskFileUpload();
                    itemList = fileUpload.parseRequest(request);
                    log.debug((Object)"Upload from GPD");
                    if (!itemList.isEmpty()) break block7;
                    log.debug((Object)"No process file in the request");
                    return "No process file in the request";
                }
                catch (FileUploadException e) {
                    log.debug((Object)"Failed to parse HTTP request", (Throwable)e);
                    return "FileUploadException";
                }
            }
            fileItem = (FileItem)itemList.get(0);
            if (fileItem.getContentType().indexOf("application/x-zip-compressed") != -1) break block8;
            log.debug((Object)"Not a process archive");
            return "Not a process archive";
        }
        try {
            log.debug((Object)("Deploying process from archive " + fileItem.getName()));
            ProcessDefinition processDefinition = this.parseProcessArchive(fileItem);
            this.deployProcessDefinition(processDefinition);
            return "Deployed process " + processDefinition.getName() + " successfully";
        }
        catch (IOException e) {
            log.debug((Object)"Failed to read process archive", (Throwable)e);
            return "IOException";
        }
    }

    private ProcessDefinition parseProcessArchive(FileItem fileItem) throws IOException {
        ZipInputStream processStream = new ZipInputStream(fileItem.getInputStream());
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)processStream);
            log.debug((Object)("Created process " + processDefinition.getName()));
            ProcessDefinition processDefinition2 = processDefinition;
            return processDefinition2;
        }
        finally {
            processStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            try {
                jbpmContext.deployProcessDefinition(processDefinition);
                log.debug((Object)("Deployed process " + processDefinition.getName() + " successfully"));
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                log.error((Object)("Failed to deploy process " + processDefinition.getName()), (Throwable)e);
                throw e;
            }
        }
        finally {
            jbpmContext.close();
        }
    }
}

