/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.web;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

/**
 * Force initialization of the hibernate session factory.
 * This will create the DB tables on new installations,
 * provided that the <code>hibernate.hbm2ddl.auto</code> property
 * is set to "create".
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class BootstrapListener implements ServletContextListener
{
   private JbpmConfiguration jbpmConfiguration;
   private static final Log log = LogFactory.getLog(BootstrapListener.class);

   public void contextInitialized(ServletContextEvent servletContextEvent)
   {
      String jbpmCfgResource =
            servletContextEvent.getServletContext()
                  .getInitParameter("jbpm.configuration.resource");
      jbpmConfiguration = JbpmConfiguration.getInstance(jbpmCfgResource);

      JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
      try
      {
         log.info("bootstrap hibernate session factory");
         jbpmContext.getSessionFactory();
      }
      catch (RuntimeException e)
      {
         jbpmContext.setRollbackOnly();

         throw e;
      }
      finally
      {
         jbpmContext.close();
      }
   }

   public void contextDestroyed(ServletContextEvent servletContextEvent)
   {

   }
}
