/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.util.JBPMClasspathContainer;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.wizard.project.NewJBPMProjectRuntimeWizardPage;
import org.jbpm.eclipse.wizard.project.NewJBPMProjectWizardPage;

public class NewJBPMProjectWizard
extends BasicNewResourceWizard {
    public static final String JBPM_CLASSPATH_CONTAINER_PATH = "JBPM/jbpm";
    public static final String JUNIT_CLASSPATH_CONTAINER_PATH = "org.eclipse.jdt.junit.JUNIT_CONTAINER/4";
    private IProject newProject;
    private WizardNewProjectCreationPage mainPage;
    private NewJBPMProjectWizardPage extraPage;
    private NewJBPMProjectRuntimeWizardPage runtimePage;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle("New jBPM Project");
        this.mainPage.setDescription("Create a new jBPM Project");
        this.addPage((IWizardPage)this.mainPage);
        this.extraPage = new NewJBPMProjectWizardPage();
        this.addPage((IWizardPage)this.extraPage);
        this.runtimePage = new NewJBPMProjectRuntimeWizardPage();
        this.addPage((IWizardPage)this.runtimePage);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.createJBPMProject();
        if (this.newProject == null) {
            return false;
        }
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private void createJBPMProject() {
        this.newProject = this.createNewProject();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IJavaProject project = JavaCore.create((IProject)NewJBPMProjectWizard.this.newProject);
                    NewJBPMProjectWizard.this.createJBPMRuntime(project, monitor);
                    NewJBPMProjectWizard.this.createOutputLocation(project, monitor);
                    NewJBPMProjectWizard.this.addJavaBuilder(project, monitor);
                    NewJBPMProjectWizard.this.setClasspath(project, monitor);
                    NewJBPMProjectWizard.this.createInitialContent(project, monitor);
                    NewJBPMProjectWizard.this.newProject.build(6, monitor);
                }
                catch (IOException iOException) {
                    ErrorDialog.openError((Shell)NewJBPMProjectWizard.this.getShell(), (String)"Problem creating jBPM project", null, null);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Throwable t) {
            JBPMEclipsePlugin.log(t);
        }
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        this.addNatures(description);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewJBPMProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", (String)("NewProject.caseVariantExistsError" + newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                JBPMEclipsePlugin.log(e);
            }
            return null;
        }
        return newProjectHandle;
    }

    private void addNatures(IProjectDescription projectDescription) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(projectDescription.getNatureIds()));
        list.add("org.eclipse.jdt.core.javanature");
        projectDescription.setNatureIds(list.toArray(new String[list.size()]));
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    private void createJBPMRuntime(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        JBPMRuntime runtime = this.runtimePage.getJBPMRuntime();
        if (runtime != null) {
            IFile file = project.getProject().getFile(".settings/.jbpm.runtime");
            String runtimeString = "<runtime>" + runtime.getName() + "</runtime>";
            if (!file.exists()) {
                IFolder folder = project.getProject().getFolder(".settings");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                file.create((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, false, null);
            }
        }
    }

    private void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = project.getProject().getFolder("bin");
        this.createFolder(folder, monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    private void addJavaBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 2];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand javaCommand = description.newCommand();
        javaCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
        newCommands[commands.length] = javaCommand;
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length + 1] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    private void setClasspath(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        project.setRawClasspath(new IClasspathEntry[0], monitor);
        this.addSourceFolders(project, monitor);
        this.addJRELibraries(project, monitor);
        NewJBPMProjectWizard.addJBPMLibraries(project, monitor);
        if (this.extraPage.createJUnitFile()) {
            NewJBPMProjectWizard.addJUnitLibrary(project, monitor);
        }
    }

    private void addSourceFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        this.addSourceFolder(project, list, "src/main/java", monitor);
        this.addSourceFolder(project, list, "src/main/resources", monitor);
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
    }

    private void addJRELibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    private static IPath getJbpmClassPathContainerPath() {
        return new Path(JBPM_CLASSPATH_CONTAINER_PATH);
    }

    private static IPath getJUnitClassPathContainerPath() {
        return new Path(JUNIT_CLASSPATH_CONTAINER_PATH);
    }

    private static void createJBPMLibraryContainer(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)NewJBPMProjectWizard.getJbpmClassPathContainerPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new JBPMClasspathContainer(project, NewJBPMProjectWizard.getJbpmClassPathContainerPath())}, (IProgressMonitor)monitor);
    }

    public static void addJBPMLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        NewJBPMProjectWizard.createJBPMLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)NewJBPMProjectWizard.getJbpmClassPathContainerPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    public static void addJUnitLibrary(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        NewJBPMProjectWizard.createJBPMLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)NewJBPMProjectWizard.getJUnitClassPathContainerPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    private void createInitialContent(IJavaProject project, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        try {
            String exampleType = this.extraPage.getExampleType();
            if (!"none".equals(exampleType)) {
                this.createProcess(project, monitor, exampleType);
                if (this.extraPage.createJavaProcessFile()) {
                    this.createProcessSampleLauncher(project, exampleType, monitor);
                }
                if (this.extraPage.createJUnitFile()) {
                    this.createProcessSampleJUnit(project, exampleType, monitor);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void createProcess(IJavaProject project, IProgressMonitor monitor, String exampleType) throws CoreException {
        String fileName = "org/jbpm/eclipse/wizard/project/" + exampleType + ".bpmn.template";
        IFolder folder = project.getProject().getFolder("src/main/resources");
        IFile file = folder.getFile("sample.bpmn");
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createProcessSampleLauncher(IJavaProject project, String exampleType, IProgressMonitor monitor) throws JavaModelException, IOException, CoreException {
        String s = "org/jbpm/eclipse/wizard/project/ProcessLauncher-" + exampleType + ".java.template";
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, monitor);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        packageFragment.createCompilationUnit("ProcessMain.java", new String(this.readStream(inputstream)), true, monitor);
        if ("advanced".equals(exampleType)) {
            folder = project.getProject().getFolder("src/main/resources/META-INF");
            this.createFolder(folder, null);
            inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jbpm/eclipse/wizard/project/ProcessLauncher-advanced-persistence.xml.template");
            IFile file = folder.getFile("persistence.xml");
            if (!file.exists()) {
                file.create(inputstream, true, monitor);
            } else {
                file.setContents(inputstream, true, false, monitor);
            }
        }
    }

    private void createProcessSampleJUnit(IJavaProject project, String exampleType, IProgressMonitor monitor) throws JavaModelException, IOException {
        String s = "org/jbpm/eclipse/wizard/project/ProcessJUnit-" + exampleType + ".java.template";
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, monitor);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        packageFragment.createCompilationUnit("ProcessTest.java", new String(this.readStream(inputstream)), true, monitor);
    }

    private byte[] readStream(InputStream inputstream) throws IOException {
        byte[] bytes = null;
        int i = 0;
        byte[] tempBytes = new byte[1024];
        int j = inputstream.read(tempBytes);
        while (j != -1) {
            byte[] tempBytes2 = new byte[i + j];
            if (i > 0) {
                System.arraycopy(bytes, 0, tempBytes2, 0, i);
            }
            System.arraycopy(tempBytes, 0, tempBytes2, i, j);
            bytes = tempBytes2;
            i += j;
            j = inputstream.read(tempBytes);
        }
        return bytes;
    }

    private void addSourceFolder(IJavaProject project, List list, String s, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder(s);
        this.createFolder(folder, monitor);
        IPackageFragmentRoot ipackagefragmentroot = project.getPackageFragmentRoot((IResource)folder);
        list.add(JavaCore.newSourceEntry((IPath)ipackagefragmentroot.getPath()));
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer container = folder.getParent();
        if (container != null && !container.exists() && container instanceof IFolder) {
            this.createFolder((IFolder)container, monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }
}

