/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.action;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.process.workitem.WorkItemRepository;

public class ImportWorkItemsDialog
extends Dialog {
    private static final String EOL = System.getProperty("line.separator");
    private TreeViewer treeViewer;
    private Text urlText;
    private Button importButton;
    private Browser documentation;
    private IJavaProject project;
    private Button addToConfigFile;
    private Button addLibraries;
    private Button registerHandlers;

    public ImportWorkItemsDialog(IJavaProject project, Shell parentShell) {
        super(parentShell);
        this.project = project;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import services");
    }

    protected Point getInitialSize() {
        return new Point(600, 800);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        top.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(top, 512);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("URL:");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.urlText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.urlText.setLayoutData((Object)gridData);
        Button findButton = new Button(composite, 0);
        findButton.setText("...");
        findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsDialog.this.findRepository();
            }
        });
        gridData = new GridData();
        findButton.setLayoutData((Object)gridData);
        Button getButton = new Button(composite, 0);
        getButton.setText("Get");
        getButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsDialog.this.getWorkDefinitions();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        getButton.setLayoutData((Object)gridData);
        this.treeViewer = new TreeViewer(composite, 2);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportWorkItemsDialog.this.importButton.setEnabled(!event.getSelection().isEmpty());
                if (!event.getSelection().isEmpty()) {
                    Object selected = ((StructuredSelection)event.getSelection()).getFirstElement();
                    if (selected instanceof WorkDefinitionImpl) {
                        String docs = ((WorkDefinitionImpl)selected).getDocumentation();
                        if (docs != null) {
                            ImportWorkItemsDialog.this.documentation.setUrl(String.valueOf(((WorkDefinitionImpl)selected).getPath()) + "/" + docs);
                        } else {
                            ImportWorkItemsDialog.this.documentation.setText("");
                        }
                    } else {
                        ImportWorkItemsDialog.this.documentation.setText("");
                    }
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object object) {
                if (object instanceof Category) {
                    return !((Category)object).getWorkDefinitions().isEmpty();
                }
                return false;
            }

            public Object getParent(Object arg0) {
                return null;
            }

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public Object[] getChildren(Object object) {
                if (object instanceof Collection) {
                    Object[] result = ((Collection)object).toArray();
                    Arrays.sort(result, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return ((Category)o1).name.compareTo(((Category)o2).name);
                        }
                    });
                    return result;
                }
                if (object instanceof Category) {
                    return ((Category)object).getWorkDefinitions().toArray();
                }
                return null;
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.importButton = new Button(composite, 0);
        this.importButton.setText("Import");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.importButton.setLayoutData((Object)gridData);
        this.importButton.setEnabled(false);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsDialog.this.importWorkDefinitions();
            }
        });
        this.addToConfigFile = new Button(composite, 16416);
        this.addToConfigFile.setText("Automatically add to service configuration file");
        GridData data = new GridData();
        data.horizontalSpan = 4;
        this.addToConfigFile.setLayoutData((Object)data);
        this.addToConfigFile.setSelection(true);
        this.addLibraries = new Button(composite, 16416);
        this.addLibraries.setText("Automatically add libraries to project");
        data = new GridData();
        data.horizontalSpan = 4;
        this.addLibraries.setLayoutData((Object)data);
        this.addLibraries.setSelection(true);
        this.registerHandlers = new Button(composite, 16416);
        this.registerHandlers.setText("Automatically register handlers");
        data = new GridData();
        data.horizontalSpan = 4;
        this.registerHandlers.setLayoutData((Object)data);
        this.registerHandlers.setSelection(true);
        try {
            this.documentation = new Browser((Composite)sashForm, 0);
        }
        catch (SWTError sWTError) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }
        return top;
    }

    private void findRepository() {
        String selectedDirectory = null;
        String dirName = this.urlText.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the jBPM service repository");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.urlText.setText(selectedDirectory);
        }
    }

    private void getWorkDefinitions() {
        HashMap<String, Category> categories = new HashMap<String, Category>();
        String url = this.urlText.getText();
        if (!url.startsWith("http") && !url.startsWith("file:")) {
            url = "file:///" + url;
        }
        Map workDefinitions = WorkItemRepository.getWorkDefinitions((String)url);
        for (WorkDefinitionImpl workDef : workDefinitions.values()) {
            Category category;
            String c = workDef.getCategory();
            if (c == null) {
                c = "Other";
            }
            if ((category = (Category)categories.get(c)) == null) {
                category = new Category(c);
                categories.put(c, category);
            }
            category.addWorkDefinition(workDef);
        }
        this.treeViewer.setInput(categories.values());
    }

    private void importWorkDefinitions() {
        IFolder folder = this.project.getProject().getFolder("src/main/resources");
        if (!folder.exists()) {
            folder = this.project.getProject().getFolder("src/main/rules");
        }
        if (!folder.exists()) {
            throw new IllegalArgumentException("Could not find src/main/resources folder.");
        }
        try {
            IFolder metaInf = folder.getFolder("META-INF");
            if (!metaInf.exists()) {
                this.createFolder(metaInf, null);
            }
            IFile workDefinitionsConfig = metaInf.getFile("drools.rulebase.conf");
            if (this.addToConfigFile.getSelection() && !workDefinitionsConfig.exists()) {
                workDefinitionsConfig.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            }
            Iterator iterator = ((StructuredSelection)this.treeViewer.getSelection()).iterator();
            HashMap<String, WorkDefinitionImpl> workDefs = new HashMap<String, WorkDefinitionImpl>();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof Category) {
                    for (WorkDefinitionImpl workDef : ((Category)o).getWorkDefinitions()) {
                        this.importWorkDefinition(workDef, folder, metaInf, workDefinitionsConfig);
                        workDefs.put(workDef.getName(), workDef);
                    }
                    continue;
                }
                if (!(o instanceof WorkDefinitionImpl)) continue;
                this.importWorkDefinition((WorkDefinitionImpl)o, folder, metaInf, workDefinitionsConfig);
                workDefs.put(((WorkDefinitionImpl)o).getName(), (WorkDefinitionImpl)o);
            }
            if (this.registerHandlers.getSelection()) {
                IFile sessionConfig = metaInf.getFile("drools.session.conf");
                if (!sessionConfig.exists()) {
                    sessionConfig.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
                }
                String[] ss = ImportWorkItemsDialog.inputStreamContentsToString(sessionConfig.getContents()).split(EOL);
                String output = "";
                boolean found = false;
                String[] stringArray = ss;
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!found && s.trim().startsWith("drools.workItemHandlers")) {
                        found = true;
                        if (!s.contains("workItemHandlers.conf")) {
                            s = String.valueOf(s) + s + " workItemDefinitions.conf";
                        }
                    }
                    output = String.valueOf(output) + s + EOL;
                    ++n2;
                }
                if (!found) {
                    output = String.valueOf(output) + "drools.workItemHandlers = workItemHandlers.conf";
                }
                String newInput = output;
                sessionConfig.setContents((InputStream)new ByteArrayInputStream(newInput.getBytes()), true, false, null);
                IFile workItemHandlersConfig = metaInf.getFile("workItemHandlers.conf");
                if (!workItemHandlersConfig.exists()) {
                    String content = "[";
                    for (WorkDefinitionImpl def : workDefs.values()) {
                        if (def.getDefaultHandler() == null) continue;
                        content = String.valueOf(content) + EOL + "  \"" + def.getName() + "\" : new " + def.getDefaultHandler() + "(),";
                    }
                    if (content.endsWith(",")) {
                        content = String.valueOf(content.substring(0, content.length() - 1)) + EOL + "]";
                    }
                    workItemHandlersConfig.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
                } else {
                    String content = ImportWorkItemsDialog.inputStreamContentsToString(workItemHandlersConfig.getContents()).trim();
                    String newContent = "[";
                    if (content.startsWith("[")) {
                        content = content.substring(1);
                    }
                    for (WorkDefinitionImpl def : workDefs.values()) {
                        if (def.getDefaultHandler() == null) continue;
                        newContent = String.valueOf(newContent) + EOL + "  \"" + def.getName() + "\" : new " + def.getDefaultHandler() + "(),";
                    }
                    newContent = String.valueOf(newContent) + content;
                    workItemHandlersConfig.setContents((InputStream)new ByteArrayInputStream(newContent.getBytes()), true, false, null);
                }
            }
            this.close();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Exception while trying to import services", t);
        }
    }

    private void importWorkDefinition(WorkDefinitionImpl workDef, IFolder resources, IFolder metaInf, IFile workDefinitionsConfig) throws Exception {
        int n;
        String defFile = String.valueOf(workDef.getPath()) + "/" + workDef.getFile();
        IFile file = metaInf.getFile(workDef.getFile());
        InputStream inputstream = new URL(defFile).openStream();
        if (!file.exists()) {
            file.create(inputstream, true, null);
        } else {
            file.setContents(inputstream, true, false, null);
        }
        if (workDef.getIcon() != null) {
            String iconFile = String.valueOf(workDef.getPath()) + "/" + workDef.getIcon();
            IFile icon = resources.getFile(workDef.getIcon());
            inputstream = new URL(iconFile).openStream();
            if (!icon.exists()) {
                icon.create(inputstream, true, null);
            } else {
                icon.setContents(inputstream, true, false, null);
            }
        }
        if (this.addToConfigFile.getSelection()) {
            String[] ss = ImportWorkItemsDialog.inputStreamContentsToString(workDefinitionsConfig.getContents()).split(System.getProperty("line.separator"));
            String output = "";
            boolean found = false;
            String[] stringArray = ss;
            int n2 = ss.length;
            n = 0;
            while (n < n2) {
                String s = stringArray[n];
                if (!found && s.trim().startsWith("drools.workDefinitions")) {
                    if (!s.contains(workDef.getFile())) {
                        s = String.valueOf(s) + " " + workDef.getFile();
                    }
                    found = true;
                }
                output = String.valueOf(output) + s + EOL;
                ++n;
            }
            if (!found) {
                output = String.valueOf(output) + EOL + "drools.workDefinitions = " + workDef.getFile();
            }
            String newInput = output;
            workDefinitionsConfig.setContents((InputStream)new ByteArrayInputStream(newInput.getBytes()), true, false, null);
        }
        String[] dependencies = workDef.getDependencies();
        if (this.addLibraries.getSelection() && dependencies != null) {
            IFolder lib = this.project.getProject().getFolder("lib");
            if (!lib.exists()) {
                this.createFolder(lib, null);
            }
            String[] stringArray = dependencies;
            n = dependencies.length;
            int n3 = 0;
            while (n3 < n) {
                String dependency = stringArray[n3];
                int index = dependency.indexOf(":");
                if (index != -1) {
                    String protocol = dependency.substring(0, index);
                    dependency = dependency.substring(index + 1);
                    if ("file".equals(protocol)) {
                        index = dependency.lastIndexOf("/");
                        String libName = index != -1 ? dependency.substring(index + 1) : dependency;
                        if (libName.startsWith("./")) {
                            libName = libName.substring(2);
                        }
                        IFile libFile = lib.getFile(libName);
                        inputstream = new URL(String.valueOf(workDef.getPath()) + "/" + dependency).openStream();
                        if (!libFile.exists()) {
                            libFile.create(inputstream, true, null);
                        } else {
                            libFile.setContents(inputstream, true, false, null);
                        }
                    }
                }
                ++n3;
            }
        }
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer container = folder.getParent();
        if (container != null && !container.exists() && container instanceof IFolder) {
            this.createFolder((IFolder)container, monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    public static String inputStreamContentsToString(InputStream inputStream) {
        StringBuilder builder = new StringBuilder();
        if (inputStream == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            reader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read inputstream");
        }
        return builder.toString();
    }

    private static class Category {
        private String name;
        private List<WorkDefinitionImpl> workDefinitions = new ArrayList<WorkDefinitionImpl>();

        public Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<WorkDefinitionImpl> getWorkDefinitions() {
            return this.workDefinitions;
        }

        public void addWorkDefinition(WorkDefinitionImpl workDefinition) {
            this.workDefinitions.add(workDefinition);
        }

        public String toString() {
            return this.name;
        }
    }
}

