/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.eclipse.preferences.JBPMRuntimesBlock;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.util.JBPMRuntimeManager;

public class JBPMRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private JBPMRuntimesBlock jBPMRuntimesBlock;

    public JBPMRuntimesPreferencePage() {
        super("Installed jBPM Runtimes");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        Label l = new Label(ancestor, 64);
        l.setFont(ancestor.getFont());
        l.setText("Add, remove or edit jBPM Runtime definitions. By default, the checked jBPM Runtime is added to the build path of newly created jBPM projects.");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        l.setLayoutData((Object)gd);
        l = new Label(ancestor, 0);
        gd = new GridData(768);
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        this.jBPMRuntimesBlock = new JBPMRuntimesBlock();
        this.jBPMRuntimesBlock.createControl(ancestor);
        JBPMRuntime[] runtimes = JBPMRuntimeManager.getJBPMRuntimes();
        this.jBPMRuntimesBlock.setJBPMRuntimes(runtimes);
        JBPMRuntime[] jBPMRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            JBPMRuntime runtime = jBPMRuntimeArray[n2];
            if (runtime.isDefault()) {
                this.jBPMRuntimesBlock.setDefaultJBPMRuntime(runtime);
                break;
            }
            ++n2;
        }
        if (this.jBPMRuntimesBlock.getDefaultJBPMRuntime() == null) {
            this.setErrorMessage("Select a default jBPM Runtime");
        }
        Control control = this.jBPMRuntimesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = 450;
        control.setLayoutData((Object)data);
        this.jBPMRuntimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBPMRuntime runtime = JBPMRuntimesPreferencePage.this.jBPMRuntimesBlock.getDefaultJBPMRuntime();
                if (runtime == null) {
                    JBPMRuntimesPreferencePage.this.setErrorMessage("Select a default jBPM Runtime");
                } else {
                    JBPMRuntimesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        if (JBPMRuntimeManager.getDefaultJBPMRuntime() != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Warning", (String)"You need to restart Eclipse to update the jBPM Runtime of existing projects.");
        }
        JBPMRuntimeManager.setJBPMRuntimes(this.jBPMRuntimesBlock.getJBPMRuntimes());
        return super.performOk();
    }
}

