/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.util.JBPMClasspathContainer;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.kie.eclipse.runtime.AbstractRuntimeManager;
import org.kie.eclipse.runtime.IRuntime;

public class JBPMRuntimeManager
extends AbstractRuntimeManager {
    private static final String RUNTIME_RECOGNIZER = "org.jbpm.eclipse.runtimeRecognizer";
    private static JBPMRuntimeManager manager;

    public static JBPMRuntimeManager getDefault() {
        if (manager == null) {
            manager = new JBPMRuntimeManager();
        }
        return manager;
    }

    public String getBundleRuntimeLocation() {
        return ".jbpm.runtime";
    }

    public String getRuntimePreferenceKey() {
        return "jBPM.Runtimes";
    }

    public String getSettingsFilename() {
        return ".jbpm.runtime";
    }

    public String getBundleSymbolicName() {
        return "org.jbpm.eclipse";
    }

    public IRuntime createNewRuntime() {
        return new JBPMRuntime();
    }

    public void logException(Throwable t) {
        JBPMEclipsePlugin.log(t);
    }

    public IPreferenceStore getPreferenceStore() {
        return JBPMEclipsePlugin.getDefault().getPreferenceStore();
    }

    public void addBuilder(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        ICommand[] commands;
        if (!JBPMClasspathContainer.hasJBPMClassPath(project)) {
            JBPMClasspathContainer cp = new JBPMClasspathContainer(project);
            JavaCore.setClasspathContainer((IPath)cp.getPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{cp}, (IProgressMonitor)monitor);
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(project.getRawClasspath()));
            list.add(JavaCore.newContainerEntry((IPath)cp.getPath()));
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
        }
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals("org.drools.eclipse.droolsbuilder")) {
                return;
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    public String getRuntimeRecognizerId() {
        return RUNTIME_RECOGNIZER;
    }
}

