/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.ProcessEngine;
import org.jboss.bpm.client.SignalListener;
import org.jboss.bpm.model.Signal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalManager {
    private static final Log log = LogFactory.getLog(SignalManager.class);
    private Set<SignalListener> listeners = new HashSet<SignalListener>();

    public static SignalManager locateSignalManager() {
        ProcessEngine engine = ProcessEngine.locateProcessEngine();
        return engine.getSignalManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignalListener(SignalListener listener) {
        Set<SignalListener> set = this.listeners;
        synchronized (set) {
            log.debug((Object)("addSignalListener: " + listener));
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SignalListener> getSignalListeners() {
        Set<SignalListener> set = this.listeners;
        synchronized (set) {
            HashSet<SignalListener> set2 = new HashSet<SignalListener>(this.listeners);
            return Collections.unmodifiableSet(set2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSignalListener(SignalListener listener) {
        Set<SignalListener> set = this.listeners;
        synchronized (set) {
            log.debug((Object)("removeSignalListener: " + listener));
            this.listeners.remove(listener);
        }
    }

    public void throwSignal(Signal signal) {
        log.debug((Object)("throwSignal: " + signal));
        Set<SignalListener> currentSet = this.getSignalListeners();
        for (SignalListener listener : currentSet) {
            if (!this.failsafeAccept(listener, signal)) continue;
            this.failsafeThrow(listener, signal);
        }
    }

    private boolean failsafeAccept(SignalListener listener, Signal signal) {
        try {
            boolean accept = listener.acceptSignal(signal);
            return accept;
        }
        catch (RuntimeException rte) {
            log.error((Object)"Signal processing error", (Throwable)rte);
            return false;
        }
    }

    private void failsafeThrow(SignalListener listener, Signal signal) {
        try {
            listener.catchSignal(signal);
        }
        catch (RuntimeException rte) {
            log.error((Object)"Signal processing error", (Throwable)rte);
        }
    }
}

