/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.endevent;

// $Id: EndEventMessageTest.java 1987 2008-08-22 18:56:09Z thomas.diesler@jboss.com $

import java.io.IOException;

import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.EventDetail.EventDetailType;
import org.jboss.bpm.runtime.BasicAttachments;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test end event with message result
 * 
 * @author thomas.diesler@jboss.com
 * @since 06-Aug-2008
 */
public class EndEventMessageTest extends DefaultEngineTestCase
{
  public void testStart() throws Exception
  {
    Process proc = getProcess();

    // Start the process
    BasicAttachments att = new BasicAttachments();
    att.addAttachment("kermit", "the frog");
    proc.startProcess(att);

    // Wait for the process to end
    proc.waitForEnd();

    // Verify the result
    Message endMessage = getMessages().get(0);
    assertEquals("the frog", endMessage.getPropertyValue("kermit"));
  }

  public Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("EndEventMessage").addStartEvent("Start");
    procBuilder.addSequenceFlow("TaskA").addTask("TaskA").addSequenceFlow("End");
    procBuilder.addEndEvent("End").addEventDetail(EventDetailType.Message).addMessageRef("EndMessage");
    MessageBuilder msgBuilder = procBuilder.addMessage("EndMessage");
    msgBuilder.addToRef(getTestID()).addProperty("kermit", null, true);
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
