/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.process;

// $Id: ProcessPropertyTest.java 1989 2008-08-22 20:13:51Z thomas.diesler@jboss.com $

import java.io.IOException;

import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Assignment.AssignTime;
import org.jboss.bpm.model.Expression.ExpressionLanguage;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Modeler-defined Properties MAY be added to a Process. These Properties are "local" to the Process. All Tasks,
 * Sub-Process objects, and Sub-Processes that are embedded SHALL have access to these Properties. The fully delineated
 * name of these properties are "<process name>.<property name>" (e.g., "Add Customer.Customer Name"). If a process is
 * embedded within another Process, then the fully delineated name SHALL also be preceded by the Parent Process name for
 * as many Parents there are until the top level Process. 
 * 
 * https://jira.jboss.org/jira/browse/JBPM-1392
 * 
 * @author thomas.diesler@jboss.com
 * @since 15-Aug-2008
 */
public class ProcessPropertyTest extends DefaultEngineTestCase
{
  /**
   * Test the the process properties can be used by Assignments
   * and finally arrive in through the End Message
   */
  public void testProcessProperties() throws Exception
  {
    Process proc = getProcess();
    proc.startProcess();
    proc.waitForEnd();

    Message endMessage = getMessages().get(0);
    assertNotNull("EndMessage expected", endMessage);
    assertEquals("bar", endMessage.getPropertyValue("propValue"));
  }

  protected Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("ProcessProperties").addStartEvent("Start").addSequenceFlow("TaskA");
    procBuilder.addAssignment(AssignTime.Start, ExpressionLanguage.MVEL, "ProcessProperties_foo", "propValue");
    procBuilder.addProperty("foo", "bar").addTask("TaskA").addSequenceFlow("End");
    procBuilder.addEndEvent("End").addEventDetail(EventDetail.EventDetailType.Message).addMessageRef("EndMessage");
    MessageBuilder msgBuilder = procBuilder.addMessage("EndMessage");
    msgBuilder.addToRef(getTestID()).addProperty("propValue", null, true);
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
