/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.pattern.control.sequence;

// $Id: SequenceTest.java 1958 2008-08-21 13:28:11Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.util.List;

import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.Signal.SignalType;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test the basic execution sequence
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Jul-2008
 */
public class SequenceTest extends DefaultEngineTestCase
{
  public void testSequence() throws Exception
  {
    // Start the Process
    Process proc = getProcess();
    proc.startProcess();
    proc.waitForEnd();

    // Validate received signals
    List<Signal> signals = getSignals();
    assertEquals(SignalType.SYSTEM_PROCESS_ENTER, signals.get(0).getSignalType());
    assertEquals(SignalType.SYSTEM_START_EVENT_ENTER, signals.get(1).getSignalType());
    assertEquals(SignalType.SYSTEM_START_EVENT_EXIT, signals.get(2).getSignalType());
    assertEquals(SignalType.SYSTEM_TASK_ENTER, signals.get(3).getSignalType());
    assertEquals(SignalType.SYSTEM_TASK_EXIT, signals.get(4).getSignalType());
    assertEquals(SignalType.SYSTEM_END_EVENT_ENTER, signals.get(5).getSignalType());
    assertEquals(SignalType.SYSTEM_END_EVENT_EXIT, signals.get(6).getSignalType());
    assertEquals(SignalType.SYSTEM_PROCESS_EXIT, signals.get(7).getSignalType());
  }

  public Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("Sequence").addStartEvent("Start").addSequenceFlow("TaskA");
    procBuilder.addTask("TaskA").addSequenceFlow("End").addEndEvent("End");
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
