/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.activity;

// $Id: ActivityPropertyMarshallerTest.java 1989 2008-08-22 20:13:51Z thomas.diesler@jboss.com $

import java.io.IOException;

import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.Process;

/**
 * 
 * An ActivityPropertyTest using the ProcessMarshaller
 * 
 * @author thomas.diesler@jboss.com
 * @since 15-Aug-2008
 */
public class ActivityPropertyMarshallerTest extends ActivityPropertyTest
{
  @Override
  protected Process getProcess() throws IOException
  {
    // Marshall the process to a string
    Process proc = super.getProcess();
    String procXML = marshallProcess(proc);
    
    // System.out.println(procXML);
    
    // Recreate the process from the marshalled process
    ProcessManager procManager = ProcessManager.locateProcessManager();
    return procManager.createProcess(procXML);
  }
}
