/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.engine;

// $Id: EngineShutdownTest.java 1946 2008-08-20 22:09:12Z thomas.diesler@jboss.com $

import org.jboss.bpm.EngineShutdownException;
import org.jboss.bpm.client.ProcessEngine;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test the engine shutdown
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Jul-2008
 */
public class EngineShutdownTest extends DefaultEngineTestCase
{
  public void testCreateProcess() throws Exception 
  {
    ProcessEngine engine = ProcessEngine.locateProcessEngine();
    
    // Create a Process through the ProcessManager
    ProcessManager pm = ProcessManager.locateProcessManager();
    String procXML = marshallProcess(getProcess());
    Process proc = pm.createProcess(procXML);
    assertNotNull("Process expected", proc);
    
    // Try to create a Process during shutdown
    try
    {
      engine.prepareForShutdown();
      proc = pm.createProcess(procXML);
      assertNotNull("Process expected", proc);
    }
    finally
    {
      engine.cancelShutdown();
    }
  }
  
  public void testRegisterProcess() throws Exception 
  {
    ProcessEngine engine = ProcessEngine.locateProcessEngine();
    
    // Create a Process through the ProcessManager
    ProcessManager pm = ProcessManager.locateProcessManager();
    String procXML = marshallProcess(getProcess());
    Process proc = pm.createProcess(procXML);
    assertNotNull("Process expected", proc);
    
    // Try to register a Process during shutdown
    try
    {
      engine.prepareForShutdown();
      pm.registerProcess(proc);
      fail("EngineShutdownException expected");
    }
    catch (EngineShutdownException ex)
    {
      // expected
    }
    finally
    {
      engine.cancelShutdown();
    }
  }
  
  public void testStartProcess() throws Exception 
  {
    ProcessEngine engine = ProcessEngine.locateProcessEngine();
    
    // Create a Process through the ProcessManager
    ProcessManager pm = ProcessManager.locateProcessManager();
    String procXML = marshallProcess(getProcess());
    Process proc = pm.createProcess(procXML);
    assertNotNull("Process expected", proc);
    
    // Try to start a Process during shutdown
    try
    {
      engine.prepareForShutdown();
      proc.startProcess(null);
      fail("EngineShutdownException expected");
    }
    catch (EngineShutdownException ex)
    {
      // expected
    }
    finally
    {
      engine.cancelShutdown();
    }
  }
  
  private Process getProcess()
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("EngineShutdown").addStartEvent("Start").addSequenceFlow("TaskA");
    procBuilder.addTask("TaskA").addSequenceFlow("End").addEndEvent("End");
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
