/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.executioncontext;

// $Id: ExecutionContextTest.java 1958 2008-08-21 13:28:11Z thomas.diesler@jboss.com $

import org.jboss.bpm.runtime.BasicExecutionContext;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test the execution context
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Jul-2008
 */
public class ExecutionContextTest extends DefaultEngineTestCase
{
  public void testStringKey() throws Exception 
  {
    ExecutionContext exContext = new BasicExecutionContext();
    
    exContext.addAttachment("foo", "bar");
    assertEquals("bar", exContext.getAttachment("foo"));
    assertNull(exContext.getAttachment(String.class, "foo"));

    exContext.removeAttachment("foo");
    assertNull(exContext.getAttachment("foo"));
  }
  
  public void testClassKey() throws Exception 
  {
    ExecutionContext exContext = new BasicExecutionContext();
    
    exContext.addAttachment(String.class, "bar");
    assertEquals("bar", exContext.getAttachment(String.class));
    
    exContext.removeAttachment(String.class);
    assertNull(exContext.getAttachment(String.class));
  }
  
  public void testStringClassKey() throws Exception 
  {
    ExecutionContext exContext = new BasicExecutionContext();
    
    exContext.addAttachment(String.class, "foo", "bar");
    assertEquals("bar", exContext.getAttachment(String.class, "foo"));
    assertNull(exContext.getAttachment("foo"));
    
    exContext.removeAttachment(String.class, "foo");
    assertNull(exContext.getAttachment(String.class, "foo"));
  }
}
