/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.task;

// $Id: SendTaskTest.java 1987 2008-08-22 18:56:09Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.util.List;

import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Task.TaskType;
import org.jboss.bpm.runtime.BasicAttachments;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test Send Task
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Jul-2008
 */
public class SendTaskTest extends DefaultEngineTestCase
{
  public void testSendTask() throws Exception
  {
    Process proc = getProcess();
    
    BasicAttachments att = new BasicAttachments();
    att.addAttachment("foo", "bar");
    proc.startProcess(att);
    proc.waitForEnd();
    
    List<Message> messages = getMessages();
    assertEquals(1, messages.size());
    assertEquals("bar", messages.get(0).getPropertyValue("foo"));
  }

  public void testSendTaskWithNoMessage() throws Exception
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("SendTaskTest").addStartEvent("Start").addSequenceFlow("TaskA");
    procBuilder.addTask("TaskA", TaskType.Send).addSequenceFlow("End").addEndEvent("End");
    try
    {
      procBuilder.getProcess();
      fail("A Message for the MessageRef attribute MUST be entered");
    }
    catch (InvalidProcessException ex)
    {
      // expected
    }
  }

  protected Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    MessageBuilder msgBuilder = procBuilder.addProcess("SendTaskTest").addMessage("SendTaskMessage");
    msgBuilder.addToRef(getTestID()).addProperty("foo", null, true);
    procBuilder.addStartEvent("Start").addSequenceFlow("TaskA");
    procBuilder.addTask("TaskA", TaskType.Send).addMessageRef("SendTaskMessage");
    procBuilder.addSequenceFlow("End").addEndEvent("End");
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
