/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.task;

// $Id: TaskExecutionHandlerTest.java 1958 2008-08-21 13:28:11Z thomas.diesler@jboss.com $

import java.io.IOException;

import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.TaskBuilder;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.ExecutionHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test ExecutionHandler attached to Task
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Jul-2008
 */
public class TaskExecutionHandlerTest extends DefaultEngineTestCase
{
  public void testExecutionHandler() throws Exception
  {
    Process proc = getProcess();
    proc.startProcess();
    proc.waitForEnd();
    
    assertEquals("kermit", TaskExecutionHandler.procProp);
    assertEquals("piggy", TaskExecutionHandler.taskProp);
    assertEquals(Boolean.TRUE, TaskExecutionHandler.procAssign);
    assertEquals(Boolean.TRUE, TaskExecutionHandler.taskAssign);
  }

  protected Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("TaskExecutionHandlerTest").addProperty("procProp", "kermit");
    procBuilder.addAssignment(Assignment.AssignTime.Start, Expression.ExpressionLanguage.MVEL, "TaskExecutionHandlerTest_procProp == 'kermit'", "procAssign");
    procBuilder.addStartEvent("Start").addSequenceFlow("TaskA");
    TaskBuilder taskBuilder = procBuilder.addTask("TaskA");
    taskBuilder.addProperty("taskProp", "piggy").addExecutionHandler(TaskExecutionHandler.class).addSequenceFlow("End");
    taskBuilder.addAssignment(Assignment.AssignTime.Start, Expression.ExpressionLanguage.MVEL, "TaskExecutionHandlerTest_TaskA_taskProp == 'piggy'", "taskAssign");
    procBuilder.addEndEvent("End");
    return procBuilder.getProcess();
  }

  @SuppressWarnings("serial")
  public static class TaskExecutionHandler implements ExecutionHandler
  {
    static String procProp;
    static String taskProp;
    static Object procAssign;
    static Object taskAssign;
    
    /**
     * This ExecutionHandler is supposed to see
     * - Process properties
     * - The result of start time process assignments
     * - Activity properties
     * - The result of start time activity assignments
     */
    public void execute(Token token)
    {
      ExecutionContext exContext = token.getExecutionContext();
      procProp = (String)exContext.getAttachment("TaskExecutionHandlerTest.procProp");
      taskProp = (String)exContext.getAttachment("TaskExecutionHandlerTest.TaskA.taskProp");
      procAssign = exContext.getAttachment("procAssign");
      taskAssign = exContext.getAttachment("taskAssign");
    }
  }
}
