/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.pattern.control.exclusivechoice;

// $Id: ExclusiveChoiceTest.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.util.List;

import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.runtime.BasicAttachments;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Exclusive data-based gateway that has conditional outgoing sequence flows. 
 * Only one of the gates is taken. It is an error if no gate is applicable. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 06-Aug-2008
 */
public class ExclusiveChoiceTest extends DefaultEngineTestCase
{
  public void testGateA() throws Exception
  {
    Process proc = getProcess();

    BasicAttachments att = new BasicAttachments();
    att.addAttachment("foo", "5");
    proc.startProcess(att);
    proc.waitForEnd();

    List<Signal> endSignals = getSignals(Signal.SignalType.SYSTEM_END_EVENT_EXIT);
    assertEquals(1, endSignals.size());
    assertEquals("EndA", endSignals.get(0).getFromRef().getKeyProperty("name"));
  }

  public void testGateB() throws Exception
  {
    Process proc = getProcess();

    BasicAttachments att = new BasicAttachments();
    att.addAttachment("foo", "15");
    proc.startProcess(att);
    proc.waitForEnd();

    List<Signal> endSignals = getSignals(Signal.SignalType.SYSTEM_END_EVENT_EXIT);
    assertEquals(1, endSignals.size());
    assertEquals("EndB", endSignals.get(0).getFromRef().getKeyProperty("name"));
  }

  public void testInvalidGate() throws Exception
  {
    Process proc = getProcess();

    BasicAttachments att = new BasicAttachments();
    att.addAttachment("foo", "10");
    proc.startProcess(att);
    try
    {
      proc.waitForEnd();
      fail("No gate defained for foo==10");
    }
    catch (RuntimeException rte)
    {
      // expected
    }
  }

  public Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess(getName()).addStartEvent("Start").addSequenceFlow("Split");
    GatewayBuilder gatewayBuilder = procBuilder.addGateway("Split", Gateway.GatewayType.Exclusive);
    gatewayBuilder.addConditionalGate("EndA", Expression.ExpressionLanguage.MVEL, "foo < 10");
    gatewayBuilder.addConditionalGate("EndB", Expression.ExpressionLanguage.MVEL, "foo > 10");
    procBuilder.addEndEvent("EndA").addEndEvent("EndB");
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
