/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.pattern.data.casedata;

// $Id: CaseDataDescriptorTest.java 1958 2008-08-21 13:28:11Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.net.URL;

import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.Process;

/**
 * Data elements are supported which are specific to a process instance or case. They can be accessed by all components
 * of the process during the execution of the case. 
 * 
 * https://jira.jboss.org/jira/browse/JBPM-1519
 * 
 * @author thomas.diesler@jboss.com
 * @since 15-Aug-2008
 */
public class CaseDataDescriptorTest extends CaseDataTest
{
  protected Process getProcess() throws IOException
  {
    URL procURL = getResourceURL("pattern/data/casedata/pattern-data-casedata-" + getDialect() + ".xml");
    ProcessManager pm = ProcessManager.locateProcessManager();
    Process proc = pm.createProcess(procURL);
    return proc;
  }
}
