/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.pattern.data.taskdata;

// $Id: TaskDataTest.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

import java.io.IOException;

import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.TaskBuilder;
import org.jboss.bpm.model.Assignment.AssignTime;
import org.jboss.bpm.model.Expression.ExpressionLanguage;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Data elements can be defined by tasks which are accessible only within the context of individual execution instances
 * of that task. 
 * 
 * https://jira.jboss.org/jira/browse/JBPM-1515
 * 
 * @author thomas.diesler@jboss.com
 * @since 15-Aug-2008
 */
public class TaskDataTest extends DefaultEngineTestCase
{
  public void testTaskDataRead() throws Exception
  {
    Process proc = getProcess();
    proc.startProcess();
    proc.waitForEnd();
    
    Message endMessage = getMessages().get(0);
    assertNotNull("EndMessage expected", endMessage);
    assertEquals("bar", endMessage.getPropertyValue("foo"));
  }

  protected Process getProcess() throws IOException
  {
    ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    procBuilder.addProcess("TaskData").addStartEvent("Start").addSequenceFlow("TaskA");
    TaskBuilder taskBuilder = procBuilder.addTask("TaskA");
    taskBuilder.addProperty("foo", "bar").addSequenceFlow("End");
    taskBuilder.addAssignment(AssignTime.Start, ExpressionLanguage.MVEL, "TaskData_TaskA_foo", "foo");
    procBuilder.addEndEvent("End").addEventDetail(EventDetail.EventDetailType.Message).addMessageRef("EndMessage");
    MessageBuilder msgBuilder = procBuilder.addMessage("EndMessage");
    msgBuilder.addToRef(getTestID()).addProperty("foo", null, true);
    Process proc = procBuilder.getProcess();
    return proc;
  }
}
