/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBActivity.java 1901 2008-08-15 12:40:19Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * An activity is a generic term for work that a company or organization performs via business processes. 
 * An activity can be atomic or non-atomic (compound). 
 * The types of activities that are a part of a Process Model are: Process, Sub-Process, and Task. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name="Activity")
public class JAXBActivity extends JAXBFlowObject
{
  private String name;
  private List<JAXBProperty> properties = new ArrayList<JAXBProperty>();

  public String getName()
  {
    return name;
  }

  @XmlAttribute(required = true)
  public void setName(String name)
  {
    this.name = name;
  }

  @XmlElement(name = "property")
  public List<JAXBProperty> getProperties()
  {
    return properties;
  }
}