/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBAssignment.java 1935 2008-08-19 19:15:14Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.Assignment.AssignTime;

/**
 * An Assignment, which is used in the definition of attributes for Process,
 * Activity, Event, Gateway, and Gate.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Assignment")
public class JAXBAssignment
{
  String to;
  JAXBExpression from;
  AssignTime assignTime;

  public String getTo()
  {
    return to;
  }

  @XmlElement
  public void setTo(String to)
  {
    this.to = to;
  }

  public JAXBExpression getFrom()
  {
    return from;
  }

  @XmlElement
  public void setFrom(JAXBExpression from)
  {
    this.from = from;
  }

  public Assignment.AssignTime getAssignTime()
  {
    return assignTime;
  }

  @XmlAttribute(name = "time")
  public void setAssignTime(Assignment.AssignTime assignTime)
  {
    this.assignTime = assignTime;
  }

}