/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

// $Id: JAXBEndEvent.java 1908 2008-08-16 14:50:11Z thomas.diesler@jboss.com $

/**
 * As the name implies, the End Event indicates where a Process will end.
 * 
 * In terms of Sequence Flow, the End Event ends the flow of the Process, and thus, will not have any outgoing Sequence Flow. An End Event can have a specific Result
 * that will appear as a marker within the center of the End Event shape. End Event Results are Message, Error, Compensation, Link, and Multiple.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "EndEvent")
public class JAXBEndEvent extends JAXBEvent
{
  private String name;
  
  @XmlElements( { 
    @XmlElement(name = "message-result", type = JAXBMessageEventDetail.class)
    })
  private List<JAXBEventDetail> result = new ArrayList<JAXBEventDetail>();

  public String getName()
  {
    return name;
  }

  @XmlAttribute(required = true)
  public void setName(String name)
  {
    this.name = name;
  }

  public List<JAXBEventDetail> getResult()
  {
    return result;
  }

  @XmlTransient
  public void setResult(List<JAXBEventDetail> result)
  {
    this.result = result;
  }
}