/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBExpression.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

import org.jboss.bpm.model.Expression;

/**
 * An Expression, which is used in the definition of attributes for @{link StartEvent},
 * 
 * @{link IntermediateEvent}, @{link Activity}, @{link ComplexGateway}, and @{link SequenceFlow}
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Expression")
public class JAXBExpression
{
  private Expression.ExpressionLanguage lang;
  private String body;

  public Expression.ExpressionLanguage getLang()
  {
    return lang;
  }

  @XmlAttribute(required = true)
  public void setLang(Expression.ExpressionLanguage lang)
  {
    this.lang = lang;
  }

  public String getBody()
  {
    return body;
  }

  @XmlValue
  public void setBody(String body)
  {
    this.body = body;
  }
}