/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;


// $Id: JAXBIntermediateEvent.java 1889 2008-08-14 13:29:28Z thomas.diesler@jboss.com $

/**
 * An Intermediate Event is an Event that occurs after a Process has been started. 
 * 
 * It will affect the Flow of the Process, but will not start or (directly) terminate the Process. 
 * An Intermediate Event will show where messages or delays are expected within the Process, 
 * disrupt the Normal Flow through exception handling, or show the extra flow required for compensating a transaction.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name="ItermediateEvent")
public class JAXBIntermediateEvent extends JAXBEvent
{
  @XmlElements( { 
    @XmlElement(name = "seqflow", type = JAXBSequenceFlow.class), 
    @XmlElement(name = "msgflow", type = JAXBMessageFlow.class) 
    })
  private JAXBFlow outFlow;
  
  public JAXBFlow getOutFlow()
  {
    return outFlow;
  }

  @XmlTransient
  public void setOutFlow(JAXBFlow outFlow)
  {
    this.outFlow = outFlow;
  }
}